@extends('layouts.landing.app')

@section('title',translate('messages.about_us'))

@section('content')
        <!-- ==== About Section ==== -->
        @php($landing_page_text = \App\Models\BusinessSetting::where(['key' => 'landing_page_text'])->first())
        @php($landing_page_text = isset($landing_page_text->value) ? json_decode($landing_page_text->value, true) : null)
        <section class="about-section">
            <div class="container">
                <div class="row gy-5">
                    {{-- <div class="col-md-6"> --}}
                    <div class="col-md-12">
                        <div class="about-content">
                            <div class="section-header text-start">
                                <h2 class="title">{{ $data_title }}</h2>
                            </div>
                            <svg class="w-50" width="560" viewBox="0 0 560 434" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_28_2046)">
                                    <path
                                        d="M314.863 335.883C315.742 335.895 316.621 335.789 317.289 335.695C320.747 335.203 324.217 335.86 327.674 336.024C329.386 336.106 330.992 335.848 332.691 335.754C334.004 335.684 335.258 335.789 336.36 334.874C336.981 334.358 337.38 333.502 337.145 332.728C336.817 331.614 335.481 331.215 334.356 330.98L326.057 329.268C324.943 329.033 322.775 328.564 322.529 327.18C322.412 326.512 322.798 325.386 322.857 324.682C322.939 323.802 322.998 322.923 323.033 322.043C323.103 320.448 323.619 318.888 321.603 318.782L315.144 318.431C314.945 318.431 314.722 318.407 314.547 318.501C314.218 318.653 314.101 319.052 314.019 319.392L313.14 322.958C312.683 324.799 312.226 326.652 311.933 328.529C311.722 329.866 311.757 331.215 311.628 332.552C311.546 333.373 311.323 334.194 311.933 334.874C312.601 335.637 313.726 335.871 314.863 335.895V335.883Z"
                                        fill="black" />
                                    <path
                                        d="M330.921 343.12C331.038 343.671 331.285 344.093 331.718 344.316C332.574 344.75 334.051 344.668 334.989 344.844C336.536 345.114 338.118 345.29 339.7 345.149C340.873 345.043 342.021 344.774 343.193 344.727C346.534 344.586 349.945 345.864 353.239 344.926C354.376 344.598 356.298 343.87 356.638 342.569C357.083 340.868 355.571 339.789 354.165 339.39C352.348 338.886 350.461 338.651 348.573 338.604C347.812 338.581 347.038 338.604 346.3 338.428C344.401 337.994 343.662 336.458 344.084 334.699C344.647 332.353 345.198 330.007 345.749 327.661C341.892 327.133 337.977 327.779 334.145 328.424C333.91 328.459 333.652 328.517 333.488 328.693C333.371 328.822 333.324 329.01 333.277 329.186C332.668 331.743 332.984 334.159 332.117 336.61C331.707 337.795 330.523 341.208 330.933 343.132L330.921 343.12Z"
                                        fill="black" />
                                    <path
                                        d="M223.765 196.545C224.504 196.287 225.301 196.157 226.063 195.982C227.528 195.641 228.383 194.949 229.415 193.929C230.071 193.284 230.751 192.615 231.595 192.252C234.303 191.091 235.662 193.448 234.666 195.77C233.892 197.588 232.65 199.465 230.833 200.38C228.841 201.389 226.789 201.447 224.996 202.878C224.539 203.242 219.78 207.241 219.979 207.488C219.089 206.373 217.155 203.969 217.26 202.468C218.596 202.081 219.499 201.142 220.261 200.016C221.011 198.914 221.691 197.694 222.828 196.99C223.121 196.803 223.437 196.662 223.754 196.556L223.765 196.545Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path d="M183.514 257.464H181.463V302.761H183.514V257.464Z" fill="#110809" />
                                    <path
                                        d="M164.549 312.261C164.549 305.576 176.376 302.773 182.284 302.761C189.317 302.749 200.018 305.341 200.018 312.261"
                                        stroke="#110809" stroke-width="2" stroke-miterlimit="10" />
                                    <path d="M182.483 314.044V302.937" stroke="#110809" stroke-width="2"
                                        stroke-miterlimit="10" />
                                    <path
                                        d="M200.018 316.777C201.623 316.777 202.925 315.475 202.925 313.868C202.925 312.262 201.623 310.959 200.018 310.959C198.413 310.959 197.111 312.262 197.111 313.868C197.111 315.475 198.413 316.777 200.018 316.777Z"
                                        fill="#110809" />
                                    <path
                                        d="M182.436 316.777C184.042 316.777 185.343 315.475 185.343 313.868C185.343 312.262 184.042 310.959 182.436 310.959C180.831 310.959 179.529 312.262 179.529 313.868C179.529 315.475 180.831 316.777 182.436 316.777Z"
                                        fill="#110809" />
                                    <path
                                        d="M164.842 316.777C166.448 316.777 167.749 315.475 167.749 313.868C167.749 312.262 166.448 310.959 164.842 310.959C163.237 310.959 161.936 312.262 161.936 313.868C161.936 315.475 163.237 316.777 164.842 316.777Z"
                                        fill="#110809" />
                                    <path
                                        d="M180.502 242.252V208.93C180.502 203.16 175.825 198.492 170.07 198.492H158.583C152.816 198.492 148.151 203.172 148.151 208.93V246.181C148.151 254.415 154.879 261.147 163.108 261.147H200.569C201.542 261.147 202.327 260.361 202.327 259.388C202.327 258.414 201.542 257.629 200.569 257.629H195.88C187.394 257.629 180.514 250.744 180.514 242.252H180.502Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M253.151 304.614C253.432 305.107 253.713 305.599 254.041 306.069C255.085 307.546 257.359 308.86 259.222 308.614C261.238 308.344 263.196 307.64 265.223 307.734C265.974 307.769 266.759 307.945 267.286 308.461C269.631 310.748 264.051 312.777 262.516 313.247L252.049 316.39C251.392 316.589 250.713 316.789 250.033 316.66C248.603 316.46 247.981 315.499 247.595 314.29C247.091 312.754 246.493 311.288 245.883 309.775C244.911 307.335 244.125 304.814 243.563 302.257C243.41 301.541 243.27 300.791 243.469 300.087C243.762 299.055 244.864 298.187 245.93 298.187C246.411 298.187 246.88 298.339 247.337 298.48C250.572 299.5 251.568 301.799 253.139 304.626L253.151 304.614Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M233.306 251.002C233.377 248.679 233.084 246.369 232.275 244.199C231.009 240.798 228.372 237.819 224.937 236.634C223.003 235.965 220.917 235.883 218.866 235.813L192.294 234.875C184.593 234.605 175.685 240.845 175.919 249.313C176.06 254.544 179.635 259.974 185.273 260.15C185.402 260.15 185.519 260.15 185.648 260.15L210.884 260.291C216.791 260.326 224.504 262.778 229.849 259.505C230.587 259.048 231.302 258.497 231.794 257.781C232.38 256.937 232.638 255.928 232.838 254.931C233.095 253.641 233.26 252.315 233.295 251.002H233.306Z"
                                        fill="black" />
                                    <path
                                        d="M198.729 248.116C206.852 252.538 191.872 260.138 184.065 260.162L170.504 260.185C162.651 260.185 156.556 256.244 156.309 248.492V225.034L186.386 225.104C186.386 225.104 189.903 243.319 198.729 248.116Z"
                                        fill="black" />
                                    <path
                                        d="M228.114 251.764C221.796 247.553 196.314 241.36 192.845 240C185.964 237.291 178.392 236.165 171.043 237.126C164.807 237.947 158.279 239.003 156.731 246.04C155.348 252.339 159.333 258.578 165.628 259.962C165.768 259.998 165.909 260.009 166.05 260.044L224.574 271.609C224.703 271.644 224.832 271.691 224.961 271.715C225.277 271.785 225.582 271.832 225.899 271.867C230.493 272.395 234.197 269.709 235.205 265.1C236.319 260.044 233.424 255.329 228.102 251.776L228.114 251.764Z"
                                        fill="black" />
                                    <path
                                        d="M220.237 307.382C220.261 309.142 220.507 310.678 222.066 312.168C224.363 314.349 227.926 314.666 230.4 316.648C230.622 316.824 230.845 317.023 230.962 317.293C231.185 317.797 230.962 318.419 230.552 318.806C228.384 320.882 223.402 318.853 220.87 318.396L211.329 316.695C210.485 316.542 209.922 315.733 210.098 314.889L211.927 305.811L212.185 304.462C212.618 302.233 214.799 300.802 217.014 301.283C218.924 301.705 220.249 303.5 220.249 305.494C220.249 306.151 220.237 306.784 220.249 307.382H220.237Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M187.711 191.537L186.96 187.596C187.922 193.296 188.836 198.996 189.703 204.708C190.524 210.092 191.063 215.581 192.786 220.776C193.36 222.536 194.216 225.656 196.209 226.371C198.729 227.274 200.405 226.899 202.937 226.922C204.027 226.922 205.128 226.946 206.183 226.664C209.125 225.879 211.013 223.04 212.302 220.284C213.744 217.211 215.174 215.205 217.928 213.188C219.839 211.792 221.679 210.291 223.449 208.708C224.094 208.121 225.734 207.089 226.039 206.268C226.379 205.353 225.817 205.025 225.16 204.356C223.039 202.186 220.683 200.204 218.678 197.917L212.724 203.43L208.481 207.359C207.801 207.992 204.062 210.49 204.12 211.112C203.745 206.655 203.347 202.128 201.823 197.917C201.647 197.436 201.46 196.943 201.401 196.439C201.331 195.759 201.507 195.079 201.636 194.41C202.339 190.891 201.823 187.15 200.299 183.913C198.682 180.464 196.642 178.564 193.091 177.403C190.946 176.7 188.801 175.996 186.574 175.667C186.199 175.609 185.695 175.656 185.613 176.019C185.577 176.16 185.624 176.312 185.659 176.453M189.281 197.237L189.656 197.178L189.281 197.237ZM188.918 197.295L189.047 197.272L188.918 197.295Z"
                                        fill="white" />
                                    <path
                                        d="M187.711 191.537L186.96 187.596C187.922 193.296 188.836 198.996 189.703 204.708C190.524 210.092 191.063 215.581 192.786 220.776C193.36 222.536 194.216 225.656 196.209 226.371C198.729 227.274 200.405 226.899 202.937 226.922C204.027 226.922 205.128 226.946 206.183 226.664C209.125 225.879 211.013 223.04 212.302 220.284C213.744 217.211 215.174 215.205 217.928 213.188C219.839 211.792 221.679 210.291 223.449 208.708C224.094 208.121 225.734 207.089 226.039 206.268C226.379 205.353 225.817 205.025 225.16 204.356C223.039 202.186 220.683 200.204 218.678 197.917L212.724 203.43L208.481 207.359C207.801 207.992 204.062 210.49 204.12 211.112C203.745 206.655 203.347 202.128 201.823 197.917C201.647 197.436 201.46 196.943 201.401 196.439C201.331 195.759 201.507 195.079 201.636 194.41C202.339 190.891 201.823 187.15 200.299 183.913C198.682 180.464 196.642 178.564 193.091 177.403C190.946 176.7 188.801 175.996 186.574 175.667C186.199 175.609 185.695 175.656 185.613 176.019C185.577 176.16 185.624 176.312 185.659 176.453M189.281 197.237L189.656 197.178L189.281 197.237ZM188.918 197.295L189.047 197.272L188.918 197.295Z"
                                        stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M254.053 302.28C248.908 291.607 245.204 280.418 241.23 269.263C239.319 263.927 237.362 258.438 233.857 253.899C232.228 251.799 230.751 250.181 228.067 249.594C225.652 249.078 223.097 249.36 220.706 249.899C219.37 250.204 218.186 250.908 216.862 251.201C215.08 251.6 212.325 251.178 211.622 253.418C211.306 254.426 211.493 255.517 211.728 256.549C212.126 258.25 212.665 259.916 213.333 261.511C214.201 263.575 215.291 265.557 216.018 267.668C216.568 269.287 216.908 270.976 217.553 272.559C218.585 275.093 220.401 277.286 222.628 278.881C223.976 279.843 225.524 280.64 226.473 282.001C227.165 282.998 227.235 284.03 227.645 285.109C228.723 287.947 229.954 290.985 232.521 292.604C233.201 293.026 233.975 293.354 234.467 293.976C234.807 294.398 234.994 294.926 235.182 295.442C235.733 296.99 236.342 298.562 237.35 299.852C238.265 301.013 239.484 301.905 240.421 303.054C241.406 304.274 241.652 305.681 242.332 307.042C242.531 307.441 254.112 302.409 254.041 302.257L254.053 302.28Z"
                                        fill="black" />
                                    <path
                                        d="M176.658 175.773L172.086 176.242C167.234 176.746 162.088 177.356 158.302 180.429C153.789 184.077 151.047 190.563 152.031 196.298C152.57 199.453 153.567 202.526 153.907 205.717C155.043 216.331 155.876 226.981 156.403 237.643C161.561 237.408 166.718 237.361 171.875 237.091C178.193 236.763 185.32 236.481 191.379 234.183C192.083 225.386 194.474 216.695 194.333 207.875L194.134 194.926"
                                        fill="white" />
                                    <path
                                        d="M176.658 175.773L172.086 176.242C167.234 176.746 162.088 177.356 158.302 180.429C153.789 184.077 151.047 190.563 152.031 196.298C152.57 199.453 153.567 202.526 153.907 205.717C155.043 216.331 155.876 226.981 156.403 237.643C161.561 237.408 166.718 237.361 171.875 237.091C178.193 236.763 185.32 236.481 191.379 234.183C192.083 225.386 194.474 216.695 194.333 207.875L194.134 194.926"
                                        stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M231.97 278.975C232.087 278.717 232.205 278.471 232.322 278.213C232.545 277.697 232.72 277.169 232.861 276.629C234.525 270.319 236.729 263.47 236.038 256.655C235.44 250.709 235.487 243.132 229.708 239.507C224.914 236.505 218.221 234.534 214.06 239.519C213.181 240.563 212.595 241.83 212.232 243.143C209.688 252.386 213.931 260.338 212.712 268.994C212.407 271.164 212.103 273.392 212.536 275.538C212.677 276.254 212.911 276.958 213.005 277.673C213.24 279.444 212.665 281.215 212.196 282.939C211.692 284.769 211.306 286.657 211.388 288.558C211.47 290.504 212.056 292.416 212.079 294.375C212.091 295.806 211.81 297.225 211.517 298.633C211.142 300.439 209.383 304.11 211.728 304.849C213.169 305.306 214.845 305.212 216.346 305.6C216.838 305.729 220.46 306.655 222.312 307.288C222.863 307.476 223.414 307.101 223.496 306.526C223.836 303.957 225.066 301.26 225.746 298.832C226.637 295.63 227.469 292.416 228.231 289.179C228.595 287.631 228.958 286.071 229.45 284.546C230.095 282.564 231.079 280.793 231.947 278.952L231.97 278.975Z"
                                        fill="black" />
                                    <path
                                        d="M188.519 163.505L186.703 152.479L179.6 154.133C175.099 155.177 172.297 159.681 173.34 164.197L173.962 166.894C174.22 167.985 174.7 168.959 175.345 169.78L173.915 176.465C173.188 179.608 175.251 182.716 178.416 183.291C181.592 183.866 184.593 181.673 185.027 178.471L186.152 170.823C188.156 169.064 189.164 166.284 188.508 163.505H188.519Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M190.43 221.844C193.782 222.583 196.209 223.943 199.162 225.527C201.706 226.899 202.21 229.409 198.822 230.031C196.982 230.359 195.083 230.699 193.255 230.3C191.426 229.902 190.782 228.776 189.551 227.544C188.496 226.488 186.703 227.004 185.179 226.348C184.581 226.09 183.995 225.703 183.772 225.093C183.561 224.495 183.772 223.838 184.007 223.24C184.218 222.712 184.452 222.16 184.874 221.773C185.706 221.011 186.996 221.07 188.098 221.328C188.871 221.504 189.656 221.68 190.442 221.844H190.43Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M187.089 154.309C185.917 155.224 184.487 155.822 183.022 156.068C181.663 156.303 180.268 156.291 178.955 156.714C175.427 157.828 175.907 161.733 176.212 164.713C176.318 165.756 175.38 169.299 173.915 168.736C172.954 168.736 172.801 167.305 172.579 166.695C172.145 165.51 171.664 164.349 171.207 163.164C170.891 162.343 170.562 161.499 170.633 160.619C170.727 159.341 171.641 158.262 171.91 157.019C172.121 156.057 171.934 155.048 172.098 154.075C172.309 152.761 173.165 151.588 174.278 150.861C175.931 149.77 177.888 150.192 179.553 149.277C180.467 148.773 181.147 147.929 181.979 147.307C183.245 146.38 184.886 146.005 186.433 146.287C187.746 146.533 189.035 147.33 189.504 148.585C189.938 149.735 189.61 151.049 189.012 152.128C188.531 152.984 187.875 153.723 187.113 154.321L187.089 154.309Z"
                                        fill="black" />
                                    <path
                                        d="M175.392 166.273C176.693 166.273 177.748 165.217 177.748 163.915C177.748 162.613 176.693 161.558 175.392 161.558C174.09 161.558 173.036 162.613 173.036 163.915C173.036 165.217 174.09 166.273 175.392 166.273Z"
                                        fill="white" />
                                    <path
                                        d="M152.019 191.278C151.457 196.075 151.351 200.931 151.07 205.752C150.765 211.018 151.011 216.355 152.488 221.445C152.957 223.04 153.555 224.635 154.633 225.902C158.56 230.476 168.242 228.599 173.575 228.599H186.761C186.832 228.388 186.878 228.177 186.949 227.978C187.3 226.172 188.461 221.891 188.789 220.073L180.42 219.392L173.188 218.806C171.254 218.653 168.3 219.099 167.972 216.531C167.855 215.627 167.984 214.677 167.632 213.845C167.105 212.601 165.604 211.909 165.264 210.607C165.007 209.622 165.44 208.414 165.511 207.417C165.616 205.939 166.308 204.579 166.894 203.218C167.902 200.884 168.64 198.445 169.086 195.946L168.664 195.923"
                                        fill="white" />
                                    <path
                                        d="M152.019 191.278C151.457 196.075 151.351 200.931 151.07 205.752C150.765 211.018 151.011 216.355 152.488 221.445C152.957 223.04 153.555 224.635 154.633 225.902C158.56 230.476 168.242 228.599 173.575 228.599H186.761C186.832 228.388 186.878 228.177 186.949 227.978C187.3 226.172 188.461 221.891 188.789 220.073L180.42 219.392L173.188 218.806C171.254 218.653 168.3 219.099 167.972 216.531C167.855 215.627 167.984 214.677 167.632 213.845C167.105 212.601 165.604 211.909 165.264 210.607C165.007 209.622 165.44 208.414 165.511 207.417C165.616 205.939 166.308 204.579 166.894 203.218C167.902 200.884 168.64 198.445 169.086 195.946L168.664 195.923"
                                        stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M198.412 226.336H247.724V228.119H196.619C196.619 227.134 197.416 226.336 198.4 226.336H198.412Z"
                                        fill="url(#paint0_linear_28_2046)" />
                                    <path
                                        d="M256.503 226.336H205.445L214.552 199.348C214.869 198.421 215.795 197.788 216.85 197.788H262.879C264.497 197.788 265.657 199.242 265.177 200.661L256.515 226.324L256.503 226.336Z"
                                        fill="url(#paint1_linear_28_2046)" />
                                    <path
                                        d="M255.612 228.119H205.199V226.336L256.503 223.99V227.227C256.503 227.72 256.104 228.119 255.612 228.119Z"
                                        fill="url(#paint2_linear_28_2046)" />
                                    <path
                                        d="M235.991 212.695C234.994 212.648 234.045 211.851 234.725 210.678C235.006 210.185 235.569 209.927 236.166 209.904C236.19 209.904 236.225 209.904 236.248 209.892C236.272 209.904 236.307 209.927 236.342 209.927C237.995 210.338 237.854 212.777 235.991 212.695Z"
                                        fill="#C9CDD1" />
                                    <path
                                        d="M204.214 210.889C204.085 211.276 203.827 211.593 203.593 211.91C203.347 212.238 203.124 212.578 202.925 212.93C202.773 213.2 202.55 213.399 202.433 213.692"
                                        fill="white" />
                                    <path
                                        d="M204.214 210.889C204.085 211.276 203.827 211.593 203.593 211.91C203.347 212.238 203.124 212.578 202.925 212.93C202.773 213.2 202.55 213.399 202.433 213.692"
                                        stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M180.479 170.647C182.038 172.583 184.112 174.072 185.519 176.125L186.011 172.196C186.105 171.48 186.339 170.835 186.503 170.167C184.417 170.647 182.671 171.199 180.479 170.659V170.647Z"
                                        fill="black" />
                                    <path
                                        d="M182.917 165.698C182.987 166.366 183.538 166.929 184.194 167.07C184.851 167.211 185.554 166.953 186.011 166.46C186.468 165.968 186.679 165.276 186.644 164.607C186.609 164.595 186.55 164.642 186.574 164.677"
                                        fill="black" />
                                    <path
                                        d="M175.732 163.059C175.345 162.977 174.911 163.106 174.653 163.411C174.395 163.716 174.337 164.173 174.524 164.525C174.712 164.877 175.157 165.076 175.532 164.971"
                                        fill="black" />
                                    <path
                                        d="M212.021 275.609C211.821 273.193 212.067 270.753 212.747 268.431C213.251 266.695 213.849 265.158 213.439 263.387C213.029 261.616 212.771 260.232 213.439 258.438"
                                        stroke="white" stroke-miterlimit="10" />
                                    <path
                                        d="M234.584 241.642C238.64 252.069 235.17 263.716 232.298 274.53C230.435 281.567 228.829 288.686 227.504 295.853"
                                        stroke="white" stroke-miterlimit="10" />
                                    <path
                                        d="M156.79 222.829C156.708 223.251 156.79 223.721 157.013 224.084C157.142 224.283 157.306 224.471 157.505 224.588C157.986 224.87 158.595 224.8 159.158 224.717"
                                        fill="black" />
                                    <path d="M183.046 200.707L183.185 200.591L183.046 200.707Z" fill="black" />
                                    <path
                                        d="M290.835 86.6102C294.719 86.6102 297.867 83.4595 297.867 79.5729C297.867 75.6864 294.719 72.5356 290.835 72.5356C286.95 72.5356 283.802 75.6864 283.802 79.5729C283.802 83.4595 286.95 86.6102 290.835 86.6102Z"
                                        fill="black" />
                                    <path
                                        d="M432.662 86.6102C436.546 86.6102 439.695 83.4595 439.695 79.5729C439.695 75.6864 436.546 72.5356 432.662 72.5356C428.778 72.5356 425.629 75.6864 425.629 79.5729C425.629 83.4595 428.778 86.6102 432.662 86.6102Z"
                                        fill="black" />
                                    <path
                                        d="M149.007 86.6102C152.891 86.6102 156.04 83.4595 156.04 79.5729C156.04 75.6864 152.891 72.5356 149.007 72.5356C145.123 72.5356 141.974 75.6864 141.974 79.5729C141.974 83.4595 145.123 86.6102 149.007 86.6102Z"
                                        fill="black" />
                                    <path
                                        d="M174.032 76.9926V76.7463C174.032 62.9883 162.885 51.8342 149.136 51.8342C135.387 51.8342 124.24 62.9883 124.24 76.7463V76.9926H174.032Z"
                                        fill="url(#paint3_linear_28_2046)" />
                                    <path
                                        d="M457.312 76.9926V76.7463C457.312 62.9883 446.165 51.8342 432.416 51.8342C418.667 51.8342 407.52 62.9883 407.52 76.7463V76.9926H457.312Z"
                                        fill="url(#paint4_linear_28_2046)" />
                                    <path d="M432.967 13V51.8459" stroke="black" stroke-width="2" stroke-miterlimit="10" />
                                    <path
                                        d="M315.484 76.9926V76.7463C315.484 62.9883 304.337 51.8342 290.588 51.8342C276.839 51.8342 265.692 62.9883 265.692 76.7463V76.9926H315.484Z"
                                        fill="url(#paint5_linear_28_2046)" />
                                    <path d="M291.139 13V51.8459" stroke="black" stroke-width="2" stroke-miterlimit="10" />
                                    <path d="M150.238 13V51.8459" stroke="black" stroke-width="2" stroke-miterlimit="10" />
                                    <path
                                        d="M397.943 212.015C397.943 213.211 398.037 213.727 396.994 214.185C395.951 214.642 394.31 214.513 393.173 214.724C390.688 215.182 388.203 215.897 386.058 217.293C382.378 219.674 377.994 220.143 374.161 222.583C373.516 222.993 372.883 223.427 372.157 223.638C371.242 223.908 370.281 223.791 369.332 223.767C366.589 223.673 363.659 224.342 361.736 226.301C361.08 226.969 360.541 228.001 360.986 228.822C361.221 229.245 361.666 229.514 362.112 229.714C365.452 231.227 368.957 230.23 372.192 228.998C374.899 227.954 378.263 227.743 381.159 227.532C385.976 227.18 390.852 227.45 395.611 226.453C398.166 225.925 400.745 225.269 403.077 224.084C405.222 223.005 407.883 221.926 408.915 219.568C409.114 219.111 409.231 218.63 409.36 218.149C410.251 214.631 411.142 211.1 412.032 207.581C412.712 204.896 412.63 202.081 412.56 199.313C412.501 196.99 412.091 194.668 411.364 192.463C410.825 190.821 410.298 188.722 409.36 187.279C408.422 185.813 406.793 184.816 405.058 184.64C401.577 184.288 398.272 186.552 398.506 190.235C398.787 194.738 397.299 199.172 398.295 203.641C398.412 204.18 398.565 204.708 398.565 205.259C398.565 205.799 398.436 206.315 398.319 206.843C397.967 208.555 397.955 210.267 397.943 212.015Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M386.562 292.51C387.969 294.598 388.965 296.592 388.59 299.383C388.039 303.488 384.698 306.209 383.808 310.197C383.726 310.561 383.667 310.936 383.761 311.323C383.948 312.074 384.687 312.66 385.402 312.848C389.27 313.868 392.657 308.168 394.849 305.975L403.113 297.659C403.851 296.92 403.746 295.583 402.89 294.703L393.665 285.168L392.306 283.749C390.055 281.403 386.691 281.133 384.851 283.174C383.257 284.933 383.386 287.936 385.003 290.305C385.542 291.079 386.058 291.818 386.539 292.533L386.562 292.51Z"
                                        fill="#110809" />
                                    <path d="M417.366 299.371H419.417V254.075H417.366V299.371Z" fill="#110809" />
                                    <path
                                        d="M436.331 308.872C436.331 302.186 424.504 299.383 418.596 299.371C411.564 299.36 400.862 301.952 400.862 308.872"
                                        stroke="#110809" stroke-width="2" stroke-miterlimit="10" />
                                    <path d="M418.385 310.655V299.547" stroke="#110809" stroke-width="2"
                                        stroke-miterlimit="10" />
                                    <path
                                        d="M400.85 313.399C402.456 313.399 403.757 312.097 403.757 310.49C403.757 308.884 402.456 307.582 400.85 307.582C399.245 307.582 397.943 308.884 397.943 310.49C397.943 312.097 399.245 313.399 400.85 313.399Z"
                                        fill="#110809" />
                                    <path
                                        d="M418.444 313.399C420.049 313.399 421.351 312.097 421.351 310.49C421.351 308.884 420.049 307.582 418.444 307.582C416.839 307.582 415.537 308.884 415.537 310.49C415.537 312.097 416.839 313.399 418.444 313.399Z"
                                        fill="#110809" />
                                    <path
                                        d="M436.026 313.399C437.631 313.399 438.933 312.097 438.933 310.49C438.933 308.884 437.631 307.582 436.026 307.582C434.421 307.582 433.119 308.884 433.119 310.49C433.119 312.097 434.421 313.399 436.026 313.399Z"
                                        fill="#110809" />
                                    <path
                                        d="M420.378 238.874V205.552C420.378 199.782 425.055 195.114 430.81 195.114H442.297C448.064 195.114 452.729 199.794 452.729 205.552V242.803C452.729 251.037 446.001 257.769 437.772 257.769H400.311C399.338 257.769 398.553 256.983 398.553 256.01C398.553 255.036 399.338 254.251 400.311 254.251H405C413.486 254.251 420.366 247.366 420.366 238.874H420.378Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M383.433 303.101C382.987 305.576 382.331 307.711 380.115 309.458C376.869 312.027 372.567 311.651 369.168 313.903C368.863 314.103 368.558 314.337 368.359 314.677C367.972 315.346 368.101 316.273 368.488 316.918C370.563 320.343 376.951 318.607 380.057 318.548L391.778 318.313C392.821 318.302 393.677 317.27 393.677 316.038V300.814C393.712 297.565 391.473 295.032 388.731 295.208C386.363 295.36 384.359 297.612 383.89 300.427C383.737 301.354 383.608 302.245 383.444 303.101H383.433Z"
                                        fill="#110809" />
                                    <path d="M405.152 219.592C405.152 219.592 405.176 219.498 405.187 219.451L405.152 219.592Z"
                                        fill="#7A483A" />
                                    <path d="M412.994 182.271L412.841 182.998L412.994 182.271Z" fill="#7A483A" />
                                    <path
                                        d="M405.269 219.041C405.246 219.181 405.211 219.322 405.176 219.451L405.281 218.923C405.281 218.923 405.281 219.005 405.269 219.041Z"
                                        fill="#7A483A" />
                                    <path d="M397.451 190.551L398.682 180.324L397.475 190.563L397.451 190.551Z"
                                        fill="#7A483A" />
                                    <path
                                        d="M399.045 180.429C399.959 177.72 401.518 175.175 404.144 173.861C404.929 173.462 405.773 173.193 406.605 172.911C408.75 172.207 410.895 171.504 413.122 171.175C413.497 171.117 414.001 171.163 414.084 171.527C414.119 171.668 414.072 171.82 414.037 171.961C413.908 172.547 414.224 173.052 414.142 173.638C414.037 174.389 413.755 175.14 413.568 175.878C413.181 177.391 412.794 178.963 412.958 180.535C413.204 182.892 411.962 184.874 411.962 187.138C411.88 187.513 410.802 192.815 410.766 192.815L397.463 190.563C397.873 187.126 397.955 183.666 399.045 180.429Z"
                                        fill="black" />
                                    <path
                                        d="M365.874 246.357C365.722 245.055 365.874 243.613 366.39 242.029C367.351 239.062 370.223 237.068 373.212 236.212C376.201 235.355 379.365 235.426 382.471 235.308C388.695 235.086 394.931 233.115 401.12 233.385C402.726 233.455 404.308 233.901 405.914 233.831C410.145 233.666 413.627 230.089 417.858 229.808C419.241 229.714 420.624 229.995 421.949 230.394C424.117 231.051 426.239 232.095 427.716 233.819C430.611 237.197 430.353 242.334 428.688 246.463C428.02 248.128 427.141 249.735 425.887 251.025C424.141 252.843 421.808 253.91 419.44 254.685C416.721 255.576 414.459 255.517 411.622 255.494L392.669 255.341C388.027 255.306 383.397 255.904 378.756 255.529C373.024 255.06 366.542 252.128 365.874 246.357Z"
                                        fill="black" />
                                    <path
                                        d="M370.551 237.666C372.837 235.907 375.591 235.074 378.791 236.223C380.397 236.798 381.803 237.865 382.929 239.144C388.602 245.583 389.715 256.233 391.391 264.302C392.364 269.005 393.22 273.732 393.958 278.482C394.169 279.843 396.549 291.947 395.763 292.346C394.99 292.733 381.944 293.941 382.061 294.234C379.553 287.713 376.599 281.192 374.56 274.518C373.411 270.741 371.536 267.258 369.988 263.645C368.195 259.446 366.624 254.708 365.769 250.216C364.807 245.125 366.437 240.821 370.551 237.678V237.666Z"
                                        fill="black" />
                                    <path
                                        d="M405.515 247.143C405.363 247.342 405.211 247.553 405.082 247.776C401.097 254.121 411.786 255.658 415.643 255.67L429.204 255.693C437.057 255.693 443.153 251.752 443.399 243.999V220.542L426.614 220.589C423.261 220.589 419.546 220.155 416.229 220.612C413.849 220.941 414.154 220.401 413.169 222.747C411.939 225.691 412.572 230.359 412.032 233.561C411.353 237.631 410.028 241.712 407.414 244.903C406.793 245.665 406.102 246.369 405.504 247.143H405.515Z"
                                        fill="url(#paint6_linear_28_2046)" />
                                    <path
                                        d="M393.337 266.718C392.47 266.39 391.344 264.889 390.395 265.111C389.516 265.323 388.731 266.965 388.355 267.692C387.336 269.662 386.761 271.902 385.285 273.615C385.144 273.779 384.992 273.932 384.792 274.014C384.359 274.178 383.89 273.896 383.55 273.591C380.713 271.058 380.514 265.968 380.315 262.414C379.998 256.526 383.046 250.579 388.016 247.413C389.668 246.357 391.485 245.606 393.267 244.821C399.069 242.252 404.648 239.202 409.946 235.707C412.243 234.194 414.412 233.162 416.955 232.177C421.281 230.488 425.969 229.972 430.564 230.711C436.143 231.614 441.746 232.752 443.516 240.68C444.887 246.85 442.508 252.526 438.358 254.039C438.265 254.075 438.171 254.098 438.077 254.133L399.561 267.012C399.479 267.047 399.409 267.082 399.327 267.117C399.127 267.187 398.916 267.246 398.694 267.305C396.9 267.715 395.013 267.387 393.325 266.73L393.337 266.718Z"
                                        fill="url(#paint7_linear_28_2046)" />
                                    <path
                                        d="M406.148 176.406C406.523 175.491 407.016 174.659 407.707 174.002C411.271 170.682 416.897 170.823 421.433 170.671C424.387 170.577 427.352 170.612 430.271 171.093C433.377 171.609 435.733 172.817 438.499 174.189C440.058 174.963 441.64 175.761 442.895 176.969C445.79 179.749 446.399 184.124 446.481 188.147C446.563 192.158 443.082 233.139 443.293 233.139C438.136 232.904 432.978 232.857 427.821 232.587C425.184 232.447 422.546 232.329 419.909 232.071C418.467 231.93 417.026 232.095 415.584 231.93C413.978 231.755 414.142 231.074 413.04 230.382C412.49 230.03 412.009 230.312 411.634 229.843C411.329 229.456 411.482 227.954 411.446 227.438C411.341 225.726 411.271 224.002 411.095 222.289C410.895 220.366 410.391 218.524 410.251 216.554C409.887 211.698 409.7 206.796 408.668 202.01C407.743 197.729 406.148 193.612 405.293 189.32C404.707 186.376 404.484 183.279 405.082 180.312C405.34 179.045 405.609 177.638 406.125 176.371L406.148 176.406Z"
                                        fill="black" />
                                    <path
                                        d="M424.996 164.161C425.641 163.329 425.477 163.493 425.735 162.402L428.255 151.541L412.994 147.987L411.177 159.012C410.532 161.792 411.528 164.572 413.533 166.331L414.658 173.978C415.08 177.18 418.092 179.374 421.269 178.799C424.445 178.224 426.497 175.116 425.77 171.973L424.984 164.161H424.996Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M414.424 168.231C416.24 168.161 418.139 167.352 418.655 165.498C418.632 165.604 418.28 165.698 418.186 165.745C417.295 166.085 416.276 166.061 415.338 165.968C414.717 165.909 414.072 165.839 413.545 165.51C413.498 165.475 413.439 165.44 413.38 165.452C413.322 165.452 413.275 165.498 413.251 165.557C413.087 165.815 413.169 166.284 413.369 166.507C413.556 166.718 413.732 166.847 413.802 167.14C413.873 167.434 413.884 167.727 413.92 168.02C413.931 168.114 414.166 168.184 414.412 168.243L414.424 168.231Z"
                                        fill="black" />
                                    <path
                                        d="M412.22 150.333C413.275 150.685 414.424 150.943 415.514 151.224C417.084 151.635 418.678 151.952 420.237 152.409C424.387 153.629 423.449 157.746 423.461 161.217C423.461 162.179 423.543 163.282 424.328 163.833C426.508 165.334 427.036 160.666 427.575 159.587C427.868 159.012 428.302 158.496 428.548 157.898C429.04 156.655 428.606 155.247 428.782 153.91C428.864 153.312 429.063 152.726 429.11 152.116C429.321 149.582 427.001 147.26 424.926 146.24C423.261 145.43 421.492 144.293 420.46 142.697C420.296 142.439 420.144 142.158 419.909 141.97C419.733 141.818 419.511 141.724 419.288 141.642C418.057 141.22 416.615 141.454 415.572 142.252C415.244 142.498 414.951 142.803 414.576 142.956C413.99 143.19 413.334 143.026 412.712 142.991C411.786 142.932 410.825 143.167 410.145 143.788C409.465 144.41 409.149 145.454 409.512 146.31C409.735 146.826 410.157 147.213 410.391 147.717C410.931 148.867 410.673 149.782 411.974 150.239C412.056 150.274 412.15 150.298 412.232 150.333H412.22Z"
                                        fill="#110809" />
                                    <path
                                        d="M423.414 161.593C424.307 161.593 425.031 160.868 425.031 159.974C425.031 159.08 424.307 158.355 423.414 158.355C422.52 158.355 421.796 159.08 421.796 159.974C421.796 160.868 422.52 161.593 423.414 161.593Z"
                                        fill="white" />
                                    <path
                                        d="M385.683 250.837C384.265 253.078 383.386 255.67 382.741 258.238C381.721 262.296 380.713 266.495 381.323 270.636C381.499 271.844 381.827 273.04 381.897 274.272C382.026 276.453 381.346 278.611 381.37 280.793C381.381 282.353 381.756 283.889 382.073 285.426C382.847 289.261 383.081 292.967 382.94 296.861C382.893 298.116 382.847 299.371 382.776 300.615C382.729 301.612 382.893 303.042 382.413 303.91C383.89 304.133 385.378 304.321 386.855 304.52C389.61 304.896 392.376 305.271 395.154 305.47C396.01 305.529 397.873 305.998 398.612 305.435C399.233 304.954 399.315 303.488 399.491 302.808C400.757 297.706 401.858 292.357 400.827 287.103C400.639 286.153 400.393 285.215 400.288 284.265C400.159 283.068 400.264 281.86 400.428 280.664C401.097 275.714 402.304 270.87 402.949 265.921C403.617 260.713 404.074 255.459 404.472 250.227C405.187 240.95 392.47 243.964 388.191 247.835C387.207 248.726 386.375 249.747 385.683 250.849V250.837Z"
                                        fill="url(#paint8_linear_28_2046)" />
                                    <path d="M347.284 135.707H346.897C346.897 135.707 347.284 135.66 347.284 135.707Z"
                                        fill="#110809" />
                                    <path
                                        d="M428.782 181.532C427.129 183.103 424.574 184.3 422.652 185.555C420.988 184.065 418.995 182.951 416.862 182.318C415.666 181.966 414.435 181.755 413.263 181.332C407.965 179.397 403.886 175.398 398.424 173.627C395.693 172.735 392.645 172.09 390.77 169.908C388.461 167.234 388.016 163.223 386.316 160.185C385.648 158.989 384.593 157.969 383.21 159.27C382.143 160.267 382.518 162.226 382.741 163.493C383.081 165.416 383.479 167.316 383.89 169.228C384.476 172.008 384.792 172.981 387.301 174.354C389.809 175.726 392.294 177.415 394.24 179.503C395.505 180.851 396.537 182.4 397.744 183.784C402.011 188.686 408.235 191.443 412.97 195.9C415.256 198.046 417.682 200.978 421.14 200.028C422.265 199.723 435.44 196.228 435.018 195.477C433.412 192.627 432.263 189.977 431.08 186.962C430.365 185.144 429.403 183.408 428.77 181.567L428.782 181.532Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path d="M443.211 189.554C441.371 192.545 438.429 194.82 435.076 195.853L443.211 189.554Z"
                                        fill="black" />
                                    <path d="M443.211 189.554C441.371 192.545 438.429 194.82 435.076 195.853" stroke="white"
                                        stroke-miterlimit="10" />
                                    <path d="M338.505 143.46L338.481 143.589L338.505 143.46Z" fill="white" />
                                    <path d="M338.505 143.46L338.481 143.589" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M393.267 217.305H335.821C334.824 217.305 333.969 216.613 333.758 215.639L326.619 182.575C326.338 181.262 327.334 180.019 328.682 180.019H386.128C387.125 180.019 387.98 180.711 388.191 181.684L395.33 214.748C395.611 216.061 394.615 217.305 393.267 217.305Z"
                                        fill="black" />
                                    <path
                                        d="M361.889 226.711L363.026 213.106C363.131 211.815 362.123 210.713 360.822 210.713C359.674 210.713 358.724 211.593 358.619 212.73L357.446 226.711H349.16V228.118H370.41V226.711H361.865H361.889Z"
                                        fill="black" />
                                    <path
                                        d="M352.078 187.584C351.914 186.188 349.699 186.165 349.863 187.584L350.39 192.146C350.554 193.542 352.77 193.565 352.606 192.146L352.078 187.584Z"
                                        fill="white" />
                                    <path
                                        d="M356.509 187.584C356.345 186.188 354.129 186.165 354.293 187.584L354.821 192.146C354.985 193.542 357.2 193.565 357.036 192.146L356.509 187.584Z"
                                        fill="white" />
                                    <path
                                        d="M360.928 187.584C360.764 186.188 358.548 186.165 358.712 187.584L359.24 192.146C359.404 193.542 361.619 193.565 361.455 192.146L360.928 187.584Z"
                                        fill="white" />
                                    <path
                                        d="M365.358 187.584C365.194 186.188 362.979 186.165 363.143 187.584L363.67 192.146C363.835 193.542 366.05 193.565 365.886 192.146L365.358 187.584Z"
                                        fill="white" />
                                    <path
                                        d="M369.789 187.584C369.625 186.188 367.41 186.165 367.574 187.584L368.101 192.146C368.265 193.542 370.48 193.565 370.316 192.146L369.789 187.584Z"
                                        fill="white" />
                                    <path
                                        d="M406.805 217.61C406.957 218.618 406.969 219.803 406.207 220.483C405.773 220.87 405.176 220.999 404.601 221.128"
                                        fill="black" />
                                    <path
                                        d="M417.999 195.982C418.139 196.721 418.76 197.354 419.499 197.506C420.237 197.659 421.058 197.342 421.492 196.721"
                                        fill="#110809" />
                                    <path
                                        d="M280.567 149.582C280.883 149.465 281.164 149.23 281.317 148.926C281.399 148.926 280.485 149.582 280.567 149.582Z"
                                        fill="#110809" />
                                    <path d="M476.124 228.001H118.532V231.954H476.124V228.001Z" fill="black" />
                                    <path d="M472.409 321.938H469.689L447.431 228.764H450.162L472.409 321.938Z" fill="black" />
                                    <path d="M447.782 321.938H445.063L422.816 228.764H425.535L447.782 321.938Z" fill="black" />
                                    <path d="M123.22 321.938H125.94L148.187 228.764H145.467L123.22 321.938Z" fill="black" />
                                    <path d="M147.847 321.938H150.566L172.813 228.764H170.094L147.847 321.938Z" fill="black" />
                                    <path
                                        d="M336.899 267.469C335.704 261.792 325.483 262.238 320.864 261.44C314.605 260.35 308.334 259.306 302.087 258.18C300.68 257.933 299.11 257.722 297.832 258.508C297.129 258.942 296.625 259.634 296.156 260.303C294.304 262.989 292.71 265.921 292.218 269.029C291.725 272.137 292.487 275.445 294.761 277.427C296.824 279.221 299.79 279.702 302.614 280.066C304.326 280.289 305.967 280.687 307.655 280.969C308.627 281.133 309.612 281.016 310.432 281.579C312.882 283.232 312.214 287.173 311.569 289.719C310.925 292.264 310.163 294.668 310.784 296.979C310.948 297.6 311.218 298.198 311.323 298.844C311.441 299.641 311.3 300.486 311.159 301.307C310.397 305.646 308.874 310.291 310.538 314.396C310.737 314.877 310.983 315.346 311.077 315.874C311.147 316.308 311.089 316.753 311.042 317.199L310.034 326.019C310.034 326.019 320.091 326.488 320.864 326.5C322.025 326.512 324.58 326.958 325.635 326.312C327.264 325.316 327.604 320.448 327.885 318.654C328.284 316.108 328.448 313.528 328.94 311.006C329.819 306.444 331.718 302.128 332.539 297.565C332.949 295.29 332.797 292.885 333.254 290.633C333.641 288.745 334.121 286.845 334.449 284.91L336.782 270.964C336.958 269.909 337.134 268.841 336.981 267.809C336.969 267.704 336.946 267.598 336.923 267.504L336.899 267.469Z"
                                        fill="black" />
                                    <path
                                        d="M334.93 293.648C334.637 294.41 334.344 295.184 334.051 295.946C333.301 297.893 332.551 299.876 332.445 301.952C332.34 304.039 332.902 306.104 332.949 308.203C333.019 311.757 331.214 314.83 331.179 318.29C331.179 319.58 331.531 320.835 331.625 322.125C331.718 323.427 331.543 324.729 331.367 326.019C331.085 328.107 330.792 330.195 330.511 332.282C330.277 333.995 329.749 335.144 331.707 335.332C336.887 335.836 341.857 335.039 347.015 334.699C347.226 334.687 347.46 334.663 347.612 334.511C347.73 334.394 347.776 334.229 347.812 334.077C349.675 326.84 351.445 319.85 352.348 312.437C352.43 311.78 352.512 311.1 352.793 310.49C353.145 309.716 353.801 309.13 354.329 308.461C355.653 306.819 355.688 305.107 356.251 303.207C356.814 301.307 357.458 299.582 357.868 297.659C358.841 293.108 359.814 288.557 360.775 284.007C361.572 280.23 362.522 276.864 360.517 273.263C359.873 272.102 358.841 271.199 357.81 270.354C348.784 263.035 337.333 258.766 325.729 258.391C321.38 258.25 315.93 257.968 314.301 253.934C313.691 252.409 313.832 250.708 313.586 249.09C312.871 244.363 305.533 243.261 301.712 244.492C296.566 246.158 294.949 252.55 294.386 257.933C293.917 262.343 293.612 266.882 294.878 271.128C296.765 277.462 302.04 282.4 308.088 285.05C312.847 287.138 318.028 287.9 323.174 288.205C327.112 288.44 330.992 287.689 334.883 287.255C337.649 286.939 337.216 287.725 336.337 290.023C335.868 291.231 335.399 292.44 334.942 293.659L334.93 293.648Z"
                                        fill="url(#paint9_linear_28_2046)" />
                                    <path
                                        d="M300.329 176.277C300.469 176.957 300.61 177.649 300.727 178.341C300.962 179.702 301.091 181.262 300.176 182.294C299.649 182.892 298.84 183.185 298.301 183.784C297.504 184.652 297.445 185.965 297.621 187.126C297.832 188.522 297.844 189.754 297.926 191.114C298.008 192.58 298.641 193.929 298.582 195.43C298.465 198.257 296.402 200.134 293.671 199.946C292.053 199.829 290.225 199.618 289.252 198.316C288.772 197.682 288.584 196.885 288.408 196.111C287.072 190.293 285.747 184.206 287.248 178.424C287.799 176.289 288.502 173.767 289.78 171.926C290.694 170.6 291.714 168.865 292.991 167.868C294.175 166.941 295.968 166.601 297.176 167.504C297.984 168.102 298.36 169.111 298.676 170.061C299.344 172.102 299.907 174.178 300.352 176.277H300.329Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M315.109 200.392C315.461 198.257 316.668 196.228 318.567 195.114C320.607 193.906 322.716 192.744 324.955 191.912C325.248 191.806 325.541 191.701 325.846 191.595C331.695 189.507 337.849 188.217 343.604 185.871C349.968 183.268 356.099 180.171 362.346 177.298C366.554 175.362 370.598 173.275 374.302 170.483C377.443 168.114 376.458 163.375 377.959 160.127C378.603 158.731 379.822 157.276 380.959 159.177C382.003 160.936 381.71 163.282 381.956 165.24C382.214 167.187 382.471 169.158 381.604 171.011C380.995 172.313 379.904 173.31 378.838 174.272L375.743 177.051C374.56 178.119 373.387 179.256 372.133 180.206C368.195 183.185 364.397 186.352 360.752 189.683C357.107 193.014 353.872 196.357 349.734 199.031C345.749 201.623 341.166 203.828 336.594 205.048C336.524 205.071 336.442 205.083 336.372 205.107C331.8 206.35 327.628 208.215 322.728 207.71C318.919 207.312 314.406 204.813 315.144 200.403L315.109 200.392Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M312.331 247.588C312.331 247.729 299.801 248.363 298.653 248.445C296.39 248.585 293.484 249.277 291.256 248.902C289.838 248.656 289.229 247.154 287.553 247.471C286.545 247.659 285.349 248.022 284.611 247.319C284.13 246.861 284.071 246.134 284.036 245.477L283.251 231.321C283.04 227.427 278.234 226.359 275.433 224.576L269.713 220.952C273.288 213.223 278.269 206.526 284.13 200.403C289.991 194.281 294.644 193.413 303.634 193.319C310.901 193.249 318.157 192.287 325.201 190.457C326.877 196.427 328.659 202.456 330.277 208.391C326.151 210.631 321.134 212.249 316.645 213.751C315.309 214.255 313.879 214.842 313.152 216.073C312.589 217.035 312.554 218.208 312.554 219.322C312.484 228.74 312.413 238.17 312.343 247.588H312.331Z"
                                        fill="black" />
                                    <path d="M468.717 384.312H447.278" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M452.459 330.406C452.459 330.195 452.494 329.984 452.529 329.773C452.905 327.474 454.721 325.714 455.964 323.732C457.171 321.809 457.863 319.568 457.956 317.305C458.132 313.047 458.015 307.593 459.844 303.664C461.496 300.11 465.411 298.187 467.427 294.856C468.541 293.014 468.881 290.833 469.373 288.733C470.158 285.402 471.424 282.107 473.651 279.503C475.386 277.485 477.636 275.972 479.852 274.495C482.009 273.052 484.189 271.597 486.627 270.741C489.838 269.604 493.39 269.228 494.878 272.536C496.074 275.21 495.476 278.987 494.21 281.508C493.109 283.69 491.362 285.473 489.721 287.291C486.873 290.446 484.271 293.812 481.926 297.354C481.27 298.339 480.625 299.395 480.485 300.568C480.344 301.705 480.684 302.843 480.836 303.993C481.563 309.787 479.184 314.466 474.718 317.985C471.19 320.765 468.986 322.348 468.095 327.169C467.544 330.148 467.298 333.315 465.646 335.86C464.966 336.892 464.087 337.783 463.278 338.722C460.301 342.217 458.449 346.65 458.039 351.225C457.839 353.512 457.347 358.672 453.678 357.64C449.177 356.374 449.728 343.225 451.041 340.117C451.604 338.792 452.447 337.572 452.705 336.153C453.057 334.265 452.33 332.318 452.436 330.406H452.459Z"
                                        fill="black" />
                                    <path
                                        d="M434.139 338.053C433.178 337.361 432.334 336.575 431.818 335.508C430.447 332.623 432.568 330.652 432.721 327.943C432.861 325.492 430.751 323.943 429.403 322.231C427.716 320.085 427.329 316.988 428.431 314.49C428.923 313.387 429.685 312.308 429.521 311.112C429.403 310.244 428.794 309.529 428.337 308.778C427.047 306.632 426.977 303.805 428.173 301.588C428.841 300.345 429.896 299.266 430.177 297.87C430.365 296.944 430.2 295.982 430.025 295.044C429.462 292.017 428.935 288.956 429.122 285.883C429.204 284.546 429.45 283.162 430.224 282.06C430.915 281.074 432.111 280.265 433.365 280.594C434.619 280.922 434.842 281.978 435.311 283.033C436.647 286.083 436.999 288.815 437.585 292.088C437.69 292.663 437.819 293.249 438.159 293.718C438.523 294.246 439.097 294.574 439.636 294.926C443.094 297.166 445.919 300.873 445.895 305.001C445.895 307.417 444.911 309.751 444.875 312.168C444.875 312.789 444.934 313.446 445.309 313.939C445.649 314.396 446.2 314.631 446.704 314.889C448.204 315.651 449.623 316.73 450.349 318.255C451.158 319.979 450.959 322.02 450.384 323.838C449.81 325.656 448.896 327.356 448.286 329.163C448.134 329.608 448.005 330.078 448.052 330.558C448.157 331.684 449.083 332.224 449.693 333.057C450.338 333.948 450.396 334.534 450.736 335.531C451.639 338.182 452.576 340.364 452.143 343.261C451.967 344.41 451.627 345.536 451.51 346.697C451.264 349.008 451.885 351.307 452.236 353.606C452.471 355.13 453.045 358.696 451.475 359.752C450.127 360.655 448.216 359.165 447.079 358.508C443.528 356.444 441.019 354.778 440.457 350.521C440.058 347.495 440.457 344 438.452 341.443C437.327 340 435.592 339.12 434.115 338.053H434.139Z"
                                        fill="url(#paint10_linear_28_2046)" />
                                    <path
                                        d="M457.558 339.918C458.425 337.643 459.597 335.496 461.051 333.549C462.106 332.13 463.313 330.816 464.251 329.327C465.763 326.934 466.548 324.143 468.013 321.715C470.252 317.997 474.73 315.874 478.82 317.997C480.262 318.748 481.481 319.838 482.677 320.929C484.013 322.149 485.337 323.404 486.451 324.835C488.678 327.708 489.956 331.192 491.198 334.617L495.593 346.733C496.285 348.656 497.926 353.031 496.32 354.931C494.761 356.772 491.35 354.122 490.635 352.585C490.166 351.588 489.463 350.697 488.596 350.017C487.482 349.16 486.064 348.586 485.384 347.366C484.669 346.087 484.798 344.199 483.497 343.542C483.122 343.355 482.688 343.308 482.29 343.167C481.176 342.78 480.461 341.713 479.852 340.692C478.469 338.382 477.414 335.778 475.937 333.549C474.999 333.831 474.167 336.669 473.522 337.572C472.596 338.886 471.436 340.035 470.123 340.962C468.107 342.358 465.657 343.319 464.321 345.384C463.583 346.533 463.29 347.894 462.891 349.196C462.328 351.06 460.559 356.456 457.675 355.541C455.694 354.919 455.788 351.577 455.765 349.993C455.706 346.568 456.315 343.12 457.534 339.918H457.558Z"
                                        fill="url(#paint11_linear_28_2046)" />
                                    <path
                                        d="M472.737 351.283H430.915V356.514H434.268L436.987 371.961C438.253 379.163 444.512 384.405 451.815 384.405C459.117 384.405 465.376 379.151 466.642 371.961L469.361 356.514H472.714V351.283H472.737Z"
                                        fill="black" />
                                    <path d="M433.096 356.948H470.557" stroke="white" stroke-miterlimit="10" />
                                    <path
                                        d="M299.473 259.165L309.589 260.385C315.648 261.112 322.224 262.097 326.409 266.542C329.022 269.31 330.323 273.122 330.722 276.911C331.121 280.699 330.699 284.523 330.265 288.311"
                                        stroke="white" stroke-width="2" stroke-miterlimit="10" />
                                    <path d="M292.522 286.786H290.471V332.083H292.522V286.786Z" fill="#110809" />
                                    <path
                                        d="M273.557 341.583C273.557 334.898 285.384 332.095 291.292 332.083C298.324 332.071 309.026 334.663 309.026 341.583"
                                        stroke="#110809" stroke-width="2" stroke-miterlimit="10" />
                                    <path d="M291.491 343.366V332.259" stroke="#110809" stroke-width="2"
                                        stroke-miterlimit="10" />
                                    <path
                                        d="M309.026 346.099C310.631 346.099 311.933 344.796 311.933 343.19C311.933 341.584 310.631 340.281 309.026 340.281C307.42 340.281 306.119 341.584 306.119 343.19C306.119 344.796 307.42 346.099 309.026 346.099Z"
                                        fill="#110809" />
                                    <path
                                        d="M291.444 346.099C293.049 346.099 294.351 344.796 294.351 343.19C294.351 341.584 293.049 340.281 291.444 340.281C289.839 340.281 288.537 341.584 288.537 343.19C288.537 344.796 289.839 346.099 291.444 346.099Z"
                                        fill="#110809" />
                                    <path
                                        d="M273.85 346.099C275.456 346.099 276.757 344.796 276.757 343.19C276.757 341.584 275.456 340.281 273.85 340.281C272.245 340.281 270.943 341.584 270.943 343.19C270.943 344.796 272.245 346.099 273.85 346.099Z"
                                        fill="#110809" />
                                    <path
                                        d="M305.416 269.721V230.828C305.416 224.096 299.25 218.642 291.643 218.642H276.476C268.869 218.642 262.703 224.096 262.703 230.828V274.307C262.703 283.913 271.588 291.771 282.43 291.771H331.882C333.16 291.771 334.203 290.856 334.203 289.718C334.203 288.581 333.16 287.666 331.882 287.666H325.694C314.5 287.666 305.416 279.632 305.416 269.721Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M279.16 165.369C277.097 165.475 275.022 165.581 273.124 166.261C269.361 167.598 267.638 170.413 265.728 173.556C263.817 176.699 260.57 178.635 258.156 181.344C253.678 186.387 253.08 194.48 256.784 200.122C258.003 201.975 259.621 203.559 261.391 204.907C271.248 212.367 287.33 207.042 293.062 196.556C296.086 191.02 294.937 184.229 293.706 178.048C293.026 174.647 293.425 171.961 296.953 170.202C297.867 169.744 298.864 169.463 299.707 168.912C301.77 167.551 302.497 164.607 301.559 162.32C300.622 160.033 298.277 158.473 295.816 158.203C294.749 158.086 293.648 158.191 292.663 158.602C290.319 159.587 289.006 162.085 286.92 163.54C284.681 165.088 281.938 165.24 279.16 165.381V165.369Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M344.108 197.365C343.99 197.424 344.026 197.588 344.108 197.706C344.53 198.386 345.385 198.714 346.182 198.656C346.979 198.597 347.718 198.175 348.316 197.659"
                                        fill="black" />
                                    <path
                                        d="M108.229 331.027C111.1 330.746 114.16 331.027 117.231 331.837C117.207 326.746 117.067 321.609 116.809 316.46C116.633 313.071 115.367 309.951 111.464 309.282C109.096 308.883 107.268 309.681 106.541 311.651C104.771 316.413 106.998 325.597 108.24 331.027H108.229Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M96.3082 290.434C96.6598 293.695 96.0972 297.389 95.9683 300.708C95.8276 304.509 97.6092 307.406 98.0429 311.041C98.4415 314.408 98.4766 318.044 98.3946 321.551C98.3946 321.703 98.5118 321.82 98.6642 321.82H120.77C120.911 321.82 121.028 321.715 121.04 321.574C121.263 319.299 121.462 317.316 121.462 317.316C121.779 314.068 121.861 311.405 120.958 308.32C120.571 307.018 120.266 305.67 120.009 304.286C119.61 302.128 119.34 299.923 119.13 297.8C118.813 294.539 118.813 291.255 118.532 287.994C118.262 284.816 117.711 281.661 117.172 278.517C115.531 268.982 113.867 259.446 111.593 250.04C110.444 245.313 109.143 240.622 107.596 236C105.767 230.523 103.482 225.245 100.551 220.249C98.7814 217.234 96.6833 213.95 93.1552 212.848C90.3772 211.98 87.2476 211.581 84.4814 212.742C80.7541 214.302 77.8706 217.363 74.7996 219.885C74.3777 221.937 73.9557 223.99 73.5455 226.043C72.5492 230.91 73.8619 236.516 76.2062 240.809C77.0853 242.404 78.1402 243.917 78.8435 245.595C79.8984 248.105 80.0977 250.884 80.9064 253.488C81.7035 256.057 83.0631 258.391 84.3642 260.748C89.252 269.639 95.2064 280.195 96.2965 290.446L96.3082 290.434Z"
                                        fill="black" />
                                    <path
                                        d="M128.483 215.276C128.964 217.41 128.624 220.108 129.995 221.984C131.343 223.826 135.492 224.459 137.591 225.222C138.048 225.386 138.528 225.562 138.845 225.937C139.63 226.84 138.927 228.377 137.837 228.846C136.747 229.315 135.481 229.069 134.309 228.811L126.045 226.981C125.482 226.852 124.908 226.723 124.404 226.441C122.998 225.644 122.505 223.885 122.294 222.278C120.759 210.854 110.057 203.289 106.424 192.592C105.498 189.847 104.923 186.997 104.361 184.159C103.528 180.019 102.767 175.855 101.876 171.726C101.243 168.759 99.5667 166.108 101.348 163.153C102.708 160.889 105.802 159.904 108.287 160.819C112.261 162.296 113.644 166.73 114.863 170.295C116.574 175.269 117.993 179.796 117.7 185.156C117.617 186.575 117.453 188.041 117.946 189.378C118.485 190.868 119.762 191.947 120.782 193.167C124.217 197.272 124.756 202.784 125.998 207.793C126.619 210.314 127.85 212.66 128.46 215.135C128.471 215.182 128.483 215.229 128.495 215.276H128.483Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M68.1654 335.871C71.1074 335.602 74.0964 335.871 76.9446 336.657C78.2574 331.766 79.4647 326.852 80.5548 321.902C81.2698 318.642 80.8244 315.651 77.097 315.018C74.8348 314.63 72.7953 315.393 71.5529 317.281C68.5405 321.855 68.3529 330.652 68.1654 335.871Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M91.8189 342.029C89.7325 343.378 87.1656 343.507 84.7627 343.448C84.5166 343.448 84.2821 343.448 84.036 343.437C80.2735 343.437 76.5109 343.296 72.7484 343.026C71.2129 342.921 69.4665 342.768 68.1771 341.83C66.6651 340.739 66.8878 338.874 67.2511 337.232C67.5676 335.825 67.7669 334.382 67.8255 332.951C69.5719 333.491 71.5646 334.054 73.3931 333.878C74.4128 333.772 75.4326 333.514 76.3703 333.092C76.8391 332.881 77.2845 332.623 77.7065 332.329C77.9292 332.165 78.5622 331.426 78.8318 331.485C79.0779 331.544 79.242 332.2 79.3592 332.388C79.6405 332.834 80.0156 333.244 80.4024 333.608C81.1526 334.312 82.0434 334.875 83.0162 335.215C83.9071 335.531 84.8448 335.684 85.7708 335.848C87.0953 336.083 88.408 336.376 89.6974 336.704C90.5061 336.904 91.3149 337.138 92.0065 337.596C92.698 338.053 93.2606 338.792 93.2958 339.625C93.3427 340.54 92.7566 341.396 91.9947 341.924C91.9361 341.971 91.8658 342.006 91.8072 342.053L91.8189 342.029Z"
                                        fill="black" />
                                    <path
                                        d="M130.816 336.306C130.593 337.361 129.327 338.159 128.178 338.499C123.126 340 117.7 338.558 112.448 338.991C111.159 339.097 109.835 339.32 108.569 338.991C105.685 338.264 105.767 334.687 106.447 332.365C106.764 331.297 107.291 330.195 106.998 329.128C109.319 329.608 111.733 329.667 114.078 329.303C114.957 329.163 115.859 328.952 116.586 328.436C116.902 328.213 117.254 327.919 117.617 328.037C117.864 328.119 118.004 328.353 118.133 328.576C119.235 330.371 120.782 331.051 122.576 331.954C123.337 332.341 123.924 332.74 124.779 332.975C125.822 333.256 126.889 333.455 127.944 333.69C129.139 333.948 130.569 334.417 130.827 335.614C130.874 335.848 130.874 336.083 130.827 336.306H130.816Z"
                                        fill="url(#paint12_linear_28_2046)" />
                                    <path
                                        d="M94.55 258.543C93.9991 253.148 93.8116 247.741 93.5537 242.287C93.2958 237.08 92.6277 231.977 91.8189 226.84C91.5142 224.94 91.7603 223.263 91.1508 221.386C90.3655 218.982 89.4044 216.613 88.0916 214.455C86.181 211.288 83.4148 208.532 79.9101 207.288C77.5307 206.444 74.8817 206.444 72.7133 207.746C70.5448 209.048 69.4196 211.124 68.3529 213.293L66.4307 217.187C65.0358 220.026 63.6293 222.888 62.7736 225.937C61.918 228.987 61.6601 232.271 62.5509 235.308C63.1253 237.255 64.2271 238.323 65.1413 240.012C66.2783 242.099 66.9581 244.469 67.0519 246.85C67.1105 248.574 66.8761 250.286 66.8057 251.999C66.6651 255.857 67.4152 259.693 68.435 263.422C68.8335 264.9 69.2906 266.378 69.361 267.903C69.4196 269.158 69.2203 270.413 69.1383 271.668C68.9273 275.069 69.5837 278.435 69.7595 281.825C69.9353 285.215 69.2438 288.1 67.9427 291.267C67.1105 293.296 66.6768 295.489 66.6651 297.682C66.6534 301.037 67.2043 304.45 66.208 307.722C65.9032 308.708 65.4578 309.646 65.071 310.608C63.3948 314.713 62.715 319.146 62.0703 323.544C62.0352 323.779 62.1993 323.99 62.4337 324.025C63.9809 324.225 69.1969 325.269 69.6775 325.327C74.4597 325.89 78.8669 324.26 83.5203 325.351C83.7313 325.398 83.9422 325.292 84.0126 325.093C87.5993 315.123 90.3538 305.048 92.2761 294.645C92.827 291.654 92.4284 288.815 92.5574 285.871C92.6043 284.804 92.9442 283.08 93.2372 282.06C94.9368 276.195 96.2847 270.636 95.2884 264.502C94.972 262.531 94.7258 260.561 94.5266 258.59L94.55 258.543Z"
                                        fill="url(#paint13_linear_28_2046)" />
                                    <path
                                        d="M101.841 158.602C99.637 156.655 96.8474 155.318 94.0225 154.778C92.9911 154.579 91.9127 154.497 90.9047 154.802C90.2248 155.013 89.627 155.4 89.0293 155.775C84.7158 158.508 81.0354 162.179 78.8669 166.883C77.097 170.73 76.1827 174.905 75.4091 179.069C74.952 181.508 70.5448 211.241 69.0914 210.819C70.8144 211.323 72.5843 211.687 74.2722 212.332C76.6985 213.247 79.1248 214.197 81.5042 215.217C86.2865 217.258 90.9164 219.416 95.9683 220.648C96.6247 220.131 97.1638 219.533 97.5975 218.618C98.7814 216.05 99.6722 213.118 100.106 210.326C101.7 200.028 102.45 189.015 105.099 178.952C106.306 174.366 107.15 169.24 105.779 164.595C105.087 162.261 103.669 160.221 101.841 158.614V158.602Z"
                                        fill="black" />
                                    <path
                                        d="M98.5587 214.795C99.8363 215.37 101.149 215.932 102.462 216.542C108.522 219.346 114.265 222.841 119.528 226.946C117.981 228.4 116.598 230.23 116.469 232.353C116.34 234.476 117.981 236.775 120.091 236.681C121.31 235.309 121.474 233.303 122.365 231.684C123.525 229.585 126.971 229.655 127.745 228.084C128.565 226.418 126.701 224.178 125.775 222.993C123.138 219.604 119.047 217.645 116.398 214.314C115.449 213.129 114.769 211.745 113.925 210.49C112.566 208.461 110.772 206.714 108.698 205.412C104.642 202.855 103.2 199.254 101.219 195.02C100.61 193.718 99.9887 192.404 99.6487 190.997C99.2033 189.202 99.2151 187.326 98.9338 185.484C98.5235 182.869 97.5272 180.382 96.3902 177.99C95.3588 175.82 94.1749 173.662 92.4167 172.031C90.6585 170.401 88.2205 169.346 85.8528 169.744C82.9108 170.237 80.6954 172.888 79.8515 175.738C79.0076 178.588 79.2654 181.661 79.6054 184.617C79.9336 187.467 80.3672 190.375 81.7035 192.909C82.9928 195.348 84.8682 197.424 86.2279 199.817C87.5876 202.21 88.2205 204.567 89.3575 206.936C91.3735 211.147 94.7727 213.082 98.5469 214.807L98.5587 214.795Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M96.8005 156.983C96.1792 157.781 95.7221 158.731 95.4525 159.716C94.0577 164.853 96.0386 171.175 98.1836 175.832C98.9689 177.544 99.2971 180.429 101.196 181.332C102.497 181.942 103.435 180.98 104.513 180.441C105.791 179.796 107.15 179.256 108.44 178.588C111.335 177.086 114.16 175.491 116.938 173.779C115.437 166.765 112.073 159.622 105.814 156.127C103.81 155.001 101.372 154.309 99.2268 155.13C98.2539 155.505 97.4334 156.174 96.7887 156.995L96.8005 156.983Z"
                                        fill="black" />
                                    <path
                                        d="M89.1348 152.081C89.7091 150.251 90.1545 148.363 90.3421 146.31C90.5531 144.035 90.5531 141.677 91.3853 139.554C92.6746 136.258 97.2811 134.124 100.645 134.933C105.392 136.071 103.962 144.046 103.529 147.6C103.318 149.336 102.005 150.568 101.079 151.998C99.5433 154.391 99.3323 158.332 99.0979 161.135C99.0744 161.452 99.0393 161.804 98.84 162.05C98.6056 162.343 98.2188 162.449 97.8437 162.519C95.9331 162.941 93.9991 163.364 92.0299 163.329C89.4513 163.282 85.3957 162.39 86.603 159.048C87.4704 156.631 88.3963 154.391 89.1231 152.057L89.1348 152.081Z"
                                        fill="white" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M102.181 129.057C100.751 128.963 99.2854 129.421 98.2188 130.394C97.7616 130.805 97.3631 131.309 96.7888 131.543C96.5075 131.661 96.191 131.696 95.8862 131.743C93.1083 132.2 90.5531 133.913 89.0879 136.317C88.7597 136.857 88.4784 137.431 88.3963 138.053C88.3377 138.546 88.3963 139.05 88.4784 139.543C88.6542 140.692 88.8769 141.83 89.1348 142.967C89.252 143.472 89.4395 143.988 89.463 144.504C89.4747 144.938 89.4161 145.337 89.545 145.771C90.0608 147.518 91.7486 146.709 92.4519 145.571C93.0262 144.645 93.3662 143.601 93.7647 142.592C94.2687 141.302 94.8899 140 95.9917 139.167C97.0466 138.37 98.4063 138.112 99.7074 137.9C101.114 137.678 103.071 137.49 104.091 136.411C105.216 135.226 106.072 133.643 105.943 131.977C105.908 131.567 105.814 131.156 105.615 130.805C105.38 130.406 105.017 130.101 104.63 129.854C103.892 129.385 103.036 129.127 102.169 129.069L102.181 129.057Z"
                                        fill="black" />
                                    <path
                                        d="M95.3119 142.076C94.7962 141.056 93.5771 140.669 92.5574 141.196C91.397 141.794 90.7523 143.448 90.9985 144.703C91.2212 145.817 92.3581 146.615 93.3662 145.982C93.835 145.853 94.2687 145.595 94.5969 145.254C95.3822 144.422 95.8628 143.155 95.3119 142.064V142.076Z"
                                        fill="white" />
                                    <path
                                        d="M93.4247 143.378C93.2958 142.803 92.4988 143.061 92.5691 143.612C92.6277 144.07 92.6277 144.457 92.9324 144.809C93.12 145.02 93.4365 144.879 93.5185 144.656C93.6826 144.234 93.5185 143.8 93.413 143.378H93.4247Z"
                                        fill="black" />
                                    <path
                                        d="M93.1317 206.596C92.9911 206.936 92.9676 207.335 93.0731 207.699C93.2489 208.285 93.7412 208.731 94.2921 208.965C94.4211 209.024 94.5617 209.071 94.6907 209.071C95.0306 209.094 95.3471 208.918 95.6401 208.754"
                                        fill="black" />
                                    <path
                                        d="M77.0267 176.359C76.8509 177.286 76.7923 178.283 76.8392 179.362C77.0267 183.432 77.9644 187.42 78.8904 191.372C81.1174 189.238 84.1884 188.252 87.1422 187.349L96.484 184.476C97.3748 184.206 98.3829 183.795 98.629 182.904C98.7111 182.599 98.6876 182.271 98.6525 181.954C98.0312 176.113 93.7413 165.393 86.1927 166.73C83.9071 167.129 81.9848 168.677 80.379 170.342C78.5505 172.231 77.4487 174.119 77.0267 176.371V176.359Z"
                                        fill="black" />
                                    <path
                                        d="M92.0416 168.442C91.8541 168.302 91.6548 168.595 91.8072 168.747C93.5537 170.647 95.0657 172.606 96.1792 174.952C97.3983 177.544 98.0078 180.336 99.051 182.986C99.133 183.209 99.4495 183.127 99.4026 182.892C98.5352 177.814 96.3316 171.644 92.0533 168.442H92.0416Z"
                                        fill="white" />
                                    <path
                                        d="M97.328 149.758C97.4452 149.946 97.621 150.333 97.6679 150.427C97.8554 150.837 98.0195 151.248 98.1836 151.67C98.8283 153.371 99.473 155.13 99.4495 156.948C99.4612 155.67 100.141 154.637 100.551 153.476C100.962 152.315 101.688 151.236 102.356 150.169C102.661 149.7 102.884 148.796 102.11 149.395C101.665 149.735 101.137 149.922 100.586 150.005C99.473 150.157 98.336 149.887 97.2459 149.664C97.2694 149.664 97.2928 149.711 97.328 149.758Z"
                                        fill="black" />
                                    <path
                                        d="M99.2385 144.844C99.1799 145.032 99.2737 145.219 99.3675 145.384C99.5667 145.712 99.8363 146.005 100.165 146.193C100.493 146.38 100.915 146.439 101.278 146.322C101.747 146.158 102.075 145.712 102.263 145.255C102.298 145.161 102.321 145.02 102.227 144.985"
                                        fill="black" />
                                    <path
                                        d="M148.679 341.736C148.808 339.93 148.948 338.417 148.96 337.537C148.972 335.895 148.995 334.241 148.726 332.611C148.351 330.347 147.425 328.224 146.628 326.078C144.858 321.316 143.662 316.12 144.752 311.159C145.491 307.816 147.214 304.755 147.917 301.412C148.421 298.984 148.374 296.474 148.819 294.046C149.183 292.064 151.715 285.496 154.797 287.924C155.313 288.334 155.594 288.968 155.829 289.589C156.696 291.888 157.212 294.34 158.384 296.498C159.638 298.808 161.619 300.708 162.592 303.148C163.541 305.505 163.459 308.133 163.19 310.654C162.217 319.428 159.275 327.825 160.494 336.821C160.705 338.346 161.139 350.814 158.9 350.814C158.138 352.843 156.907 355.986 154.516 356.514C148.022 357.933 148.233 348.058 148.679 341.748V341.736Z"
                                        fill="url(#paint14_linear_28_2046)" />
                                    <path
                                        d="M126.221 357.018C123.677 359.423 121.779 362.425 117.993 363.047C113.245 363.821 110.819 359.317 112.519 355.13C113.632 352.374 115.965 350.345 117.993 348.163C120.243 345.735 122.189 343.014 123.759 340.082C124.932 337.9 125.963 335.519 127.967 334.053C129.268 333.103 130.863 332.634 132.421 332.2C135.492 331.32 138.798 330.453 141.834 331.473C143.732 332.106 145.315 333.432 146.733 334.827C155.008 343.108 154.399 353.84 152.477 364.513C152.301 365.487 152.043 366.589 151.175 367.047C149.769 367.797 148.198 366.249 147.706 364.736C146.51 361.077 147.237 357.839 144.834 354.602C142.889 351.975 139.372 349.887 138.306 346.767C137.977 345.817 137.837 344.762 137.204 343.988C136.571 343.214 135.164 342.944 134.637 343.8C134.355 344.246 134.426 344.82 134.473 345.348C134.719 348.703 133.125 352.127 130.405 354.098C129.292 354.907 128.003 355.482 126.948 356.373C126.701 356.584 126.467 356.796 126.233 357.018H126.221Z"
                                        fill="black" />
                                    <path
                                        d="M153.531 346.04C153.52 345.559 153.531 345.078 153.578 344.598C154.141 339.542 161.162 338.827 164.643 336.575C167.96 334.417 170.012 329.913 174.29 334.335C176.341 336.458 177.736 340.305 178.146 343.178C178.955 348.726 179.729 354.286 180.467 359.845C180.631 361.088 180.783 362.414 180.209 363.528C179.154 365.592 176.025 365.768 174.161 364.396C171.547 362.789 170.598 358.426 169.59 355.81C169.109 354.567 168.628 353.289 168.722 351.963C168.839 350.333 169.812 348.785 169.554 347.178C169.472 346.674 169.121 346.099 168.617 346.157C168.453 346.181 168.312 346.263 168.171 346.357C165.874 347.846 165.1 350.18 163.682 352.35C162.193 354.637 161.021 354.368 159.298 355.951C155.723 359.223 156.802 366.613 155.512 371.011C155.184 372.137 154.082 373.474 153.109 372.817C152.723 372.559 152.57 372.055 152.465 371.597C151.281 366.695 151.293 361.511 152.5 356.62C153.016 354.555 153.742 352.503 153.801 350.38C153.836 348.937 153.567 347.495 153.52 346.064L153.531 346.04Z"
                                        fill="url(#paint15_linear_28_2046)" />
                                    <path
                                        d="M169.191 362.05H134.906V366.343H137.661L139.9 379.01C140.943 384.91 146.065 389.214 152.055 389.214C158.044 389.214 163.166 384.91 164.21 379.01L166.448 366.343H169.203V362.05H169.191Z"
                                        fill="black" />
                                    <path d="M136.688 366.695H167.398" stroke="white" stroke-miterlimit="10" />
                                    <path d="M144.846 389.414H177.15" stroke="black" stroke-miterlimit="10" />
                                    <path
                                        d="M423.554 159.282C423.812 159.247 424.094 159.376 424.234 159.611C424.375 159.845 424.363 160.15 424.199 160.361C424.07 160.537 423.871 160.643 423.66 160.713C423.636 160.713 423.613 160.713 423.613 160.701"
                                        fill="black" />
                                    <path
                                        d="M412.431 160.983C412.372 161.194 412.478 161.405 412.595 161.581C412.794 161.874 413.076 162.144 413.404 162.285C413.802 162.461 414.271 162.449 414.67 162.285C415.068 162.12 415.396 161.792 415.584 161.393H415.514"
                                        fill="black" />
                                </g>
                                <defs>
                                    <linearGradient id="paint0_linear_28_2046" x1="196.619" y1="226.336" x2="196.868"
                                        y2="230.437" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint1_linear_28_2046" x1="205.445" y1="197.788" x2="237.84"
                                        y2="236.792" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint2_linear_28_2046" x1="205.199" y1="223.99" x2="206.508"
                                        y2="233.338" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint3_linear_28_2046" x1="124.24" y1="51.8342" x2="153.045"
                                        y2="84.5796" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint4_linear_28_2046" x1="407.52" y1="51.8342" x2="436.325"
                                        y2="84.5796" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint5_linear_28_2046" x1="265.692" y1="51.8342" x2="294.497"
                                        y2="84.5796" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint6_linear_28_2046" x1="404.206" y1="220.403" x2="441.148"
                                        y2="243.968" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint7_linear_28_2046" x1="380.292" y1="230.382" x2="429.922"
                                        y2="271.898" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint8_linear_28_2046" x1="381.138" y1="244.098" x2="410.717"
                                        y2="250.541" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint9_linear_28_2046" x1="293.98" y1="244.026" x2="370.041"
                                        y2="276.377" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint10_linear_28_2046" x1="427.321" y1="280.519" x2="459.683"
                                        y2="286.414" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint11_linear_28_2046" x1="455.761" y1="317.154" x2="495.428"
                                        y2="341.566" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint12_linear_28_2046" x1="106.054" y1="328.01" x2="118.604"
                                        y2="343.991" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint13_linear_28_2046" x1="61.9951" y1="206.703" x2="105.446"
                                        y2="213.772" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint14_linear_28_2046" x1="144.335" y1="287.393" x2="168.963"
                                        y2="291.28" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <linearGradient id="paint15_linear_28_2046" x1="151.586" y1="332.46" x2="184.511"
                                        y2="346.006" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#00A759" />
                                        <stop offset="0.484375" stop-color="#03C168" />
                                        <stop offset="1" stop-color="#00B05E" />
                                    </linearGradient>
                                    <clipPath id="clip0_28_2046">
                                        <rect width="435" height="377" fill="white" transform="translate(62 13)" />
                                    </clipPath>
                                </defs>
                            </svg>
                            {!!$data!!}
                        </div>
                    </div>
                    {{-- <div class="col-md-6">
                        <svg class="w-100" width="560" viewBox="0 0 560 434" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_28_2046)">
                                <path
                                    d="M314.863 335.883C315.742 335.895 316.621 335.789 317.289 335.695C320.747 335.203 324.217 335.86 327.674 336.024C329.386 336.106 330.992 335.848 332.691 335.754C334.004 335.684 335.258 335.789 336.36 334.874C336.981 334.358 337.38 333.502 337.145 332.728C336.817 331.614 335.481 331.215 334.356 330.98L326.057 329.268C324.943 329.033 322.775 328.564 322.529 327.18C322.412 326.512 322.798 325.386 322.857 324.682C322.939 323.802 322.998 322.923 323.033 322.043C323.103 320.448 323.619 318.888 321.603 318.782L315.144 318.431C314.945 318.431 314.722 318.407 314.547 318.501C314.218 318.653 314.101 319.052 314.019 319.392L313.14 322.958C312.683 324.799 312.226 326.652 311.933 328.529C311.722 329.866 311.757 331.215 311.628 332.552C311.546 333.373 311.323 334.194 311.933 334.874C312.601 335.637 313.726 335.871 314.863 335.895V335.883Z"
                                    fill="black" />
                                <path
                                    d="M330.921 343.12C331.038 343.671 331.285 344.093 331.718 344.316C332.574 344.75 334.051 344.668 334.989 344.844C336.536 345.114 338.118 345.29 339.7 345.149C340.873 345.043 342.021 344.774 343.193 344.727C346.534 344.586 349.945 345.864 353.239 344.926C354.376 344.598 356.298 343.87 356.638 342.569C357.083 340.868 355.571 339.789 354.165 339.39C352.348 338.886 350.461 338.651 348.573 338.604C347.812 338.581 347.038 338.604 346.3 338.428C344.401 337.994 343.662 336.458 344.084 334.699C344.647 332.353 345.198 330.007 345.749 327.661C341.892 327.133 337.977 327.779 334.145 328.424C333.91 328.459 333.652 328.517 333.488 328.693C333.371 328.822 333.324 329.01 333.277 329.186C332.668 331.743 332.984 334.159 332.117 336.61C331.707 337.795 330.523 341.208 330.933 343.132L330.921 343.12Z"
                                    fill="black" />
                                <path
                                    d="M223.765 196.545C224.504 196.287 225.301 196.157 226.063 195.982C227.528 195.641 228.383 194.949 229.415 193.929C230.071 193.284 230.751 192.615 231.595 192.252C234.303 191.091 235.662 193.448 234.666 195.77C233.892 197.588 232.65 199.465 230.833 200.38C228.841 201.389 226.789 201.447 224.996 202.878C224.539 203.242 219.78 207.241 219.979 207.488C219.089 206.373 217.155 203.969 217.26 202.468C218.596 202.081 219.499 201.142 220.261 200.016C221.011 198.914 221.691 197.694 222.828 196.99C223.121 196.803 223.437 196.662 223.754 196.556L223.765 196.545Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path d="M183.514 257.464H181.463V302.761H183.514V257.464Z" fill="#110809" />
                                <path
                                    d="M164.549 312.261C164.549 305.576 176.376 302.773 182.284 302.761C189.317 302.749 200.018 305.341 200.018 312.261"
                                    stroke="#110809" stroke-width="2" stroke-miterlimit="10" />
                                <path d="M182.483 314.044V302.937" stroke="#110809" stroke-width="2"
                                    stroke-miterlimit="10" />
                                <path
                                    d="M200.018 316.777C201.623 316.777 202.925 315.475 202.925 313.868C202.925 312.262 201.623 310.959 200.018 310.959C198.413 310.959 197.111 312.262 197.111 313.868C197.111 315.475 198.413 316.777 200.018 316.777Z"
                                    fill="#110809" />
                                <path
                                    d="M182.436 316.777C184.042 316.777 185.343 315.475 185.343 313.868C185.343 312.262 184.042 310.959 182.436 310.959C180.831 310.959 179.529 312.262 179.529 313.868C179.529 315.475 180.831 316.777 182.436 316.777Z"
                                    fill="#110809" />
                                <path
                                    d="M164.842 316.777C166.448 316.777 167.749 315.475 167.749 313.868C167.749 312.262 166.448 310.959 164.842 310.959C163.237 310.959 161.936 312.262 161.936 313.868C161.936 315.475 163.237 316.777 164.842 316.777Z"
                                    fill="#110809" />
                                <path
                                    d="M180.502 242.252V208.93C180.502 203.16 175.825 198.492 170.07 198.492H158.583C152.816 198.492 148.151 203.172 148.151 208.93V246.181C148.151 254.415 154.879 261.147 163.108 261.147H200.569C201.542 261.147 202.327 260.361 202.327 259.388C202.327 258.414 201.542 257.629 200.569 257.629H195.88C187.394 257.629 180.514 250.744 180.514 242.252H180.502Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M253.151 304.614C253.432 305.107 253.713 305.599 254.041 306.069C255.085 307.546 257.359 308.86 259.222 308.614C261.238 308.344 263.196 307.64 265.223 307.734C265.974 307.769 266.759 307.945 267.286 308.461C269.631 310.748 264.051 312.777 262.516 313.247L252.049 316.39C251.392 316.589 250.713 316.789 250.033 316.66C248.603 316.46 247.981 315.499 247.595 314.29C247.091 312.754 246.493 311.288 245.883 309.775C244.911 307.335 244.125 304.814 243.563 302.257C243.41 301.541 243.27 300.791 243.469 300.087C243.762 299.055 244.864 298.187 245.93 298.187C246.411 298.187 246.88 298.339 247.337 298.48C250.572 299.5 251.568 301.799 253.139 304.626L253.151 304.614Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M233.306 251.002C233.377 248.679 233.084 246.369 232.275 244.199C231.009 240.798 228.372 237.819 224.937 236.634C223.003 235.965 220.917 235.883 218.866 235.813L192.294 234.875C184.593 234.605 175.685 240.845 175.919 249.313C176.06 254.544 179.635 259.974 185.273 260.15C185.402 260.15 185.519 260.15 185.648 260.15L210.884 260.291C216.791 260.326 224.504 262.778 229.849 259.505C230.587 259.048 231.302 258.497 231.794 257.781C232.38 256.937 232.638 255.928 232.838 254.931C233.095 253.641 233.26 252.315 233.295 251.002H233.306Z"
                                    fill="black" />
                                <path
                                    d="M198.729 248.116C206.852 252.538 191.872 260.138 184.065 260.162L170.504 260.185C162.651 260.185 156.556 256.244 156.309 248.492V225.034L186.386 225.104C186.386 225.104 189.903 243.319 198.729 248.116Z"
                                    fill="black" />
                                <path
                                    d="M228.114 251.764C221.796 247.553 196.314 241.36 192.845 240C185.964 237.291 178.392 236.165 171.043 237.126C164.807 237.947 158.279 239.003 156.731 246.04C155.348 252.339 159.333 258.578 165.628 259.962C165.768 259.998 165.909 260.009 166.05 260.044L224.574 271.609C224.703 271.644 224.832 271.691 224.961 271.715C225.277 271.785 225.582 271.832 225.899 271.867C230.493 272.395 234.197 269.709 235.205 265.1C236.319 260.044 233.424 255.329 228.102 251.776L228.114 251.764Z"
                                    fill="black" />
                                <path
                                    d="M220.237 307.382C220.261 309.142 220.507 310.678 222.066 312.168C224.363 314.349 227.926 314.666 230.4 316.648C230.622 316.824 230.845 317.023 230.962 317.293C231.185 317.797 230.962 318.419 230.552 318.806C228.384 320.882 223.402 318.853 220.87 318.396L211.329 316.695C210.485 316.542 209.922 315.733 210.098 314.889L211.927 305.811L212.185 304.462C212.618 302.233 214.799 300.802 217.014 301.283C218.924 301.705 220.249 303.5 220.249 305.494C220.249 306.151 220.237 306.784 220.249 307.382H220.237Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M187.711 191.537L186.96 187.596C187.922 193.296 188.836 198.996 189.703 204.708C190.524 210.092 191.063 215.581 192.786 220.776C193.36 222.536 194.216 225.656 196.209 226.371C198.729 227.274 200.405 226.899 202.937 226.922C204.027 226.922 205.128 226.946 206.183 226.664C209.125 225.879 211.013 223.04 212.302 220.284C213.744 217.211 215.174 215.205 217.928 213.188C219.839 211.792 221.679 210.291 223.449 208.708C224.094 208.121 225.734 207.089 226.039 206.268C226.379 205.353 225.817 205.025 225.16 204.356C223.039 202.186 220.683 200.204 218.678 197.917L212.724 203.43L208.481 207.359C207.801 207.992 204.062 210.49 204.12 211.112C203.745 206.655 203.347 202.128 201.823 197.917C201.647 197.436 201.46 196.943 201.401 196.439C201.331 195.759 201.507 195.079 201.636 194.41C202.339 190.891 201.823 187.15 200.299 183.913C198.682 180.464 196.642 178.564 193.091 177.403C190.946 176.7 188.801 175.996 186.574 175.667C186.199 175.609 185.695 175.656 185.613 176.019C185.577 176.16 185.624 176.312 185.659 176.453M189.281 197.237L189.656 197.178L189.281 197.237ZM188.918 197.295L189.047 197.272L188.918 197.295Z"
                                    fill="white" />
                                <path
                                    d="M187.711 191.537L186.96 187.596C187.922 193.296 188.836 198.996 189.703 204.708C190.524 210.092 191.063 215.581 192.786 220.776C193.36 222.536 194.216 225.656 196.209 226.371C198.729 227.274 200.405 226.899 202.937 226.922C204.027 226.922 205.128 226.946 206.183 226.664C209.125 225.879 211.013 223.04 212.302 220.284C213.744 217.211 215.174 215.205 217.928 213.188C219.839 211.792 221.679 210.291 223.449 208.708C224.094 208.121 225.734 207.089 226.039 206.268C226.379 205.353 225.817 205.025 225.16 204.356C223.039 202.186 220.683 200.204 218.678 197.917L212.724 203.43L208.481 207.359C207.801 207.992 204.062 210.49 204.12 211.112C203.745 206.655 203.347 202.128 201.823 197.917C201.647 197.436 201.46 196.943 201.401 196.439C201.331 195.759 201.507 195.079 201.636 194.41C202.339 190.891 201.823 187.15 200.299 183.913C198.682 180.464 196.642 178.564 193.091 177.403C190.946 176.7 188.801 175.996 186.574 175.667C186.199 175.609 185.695 175.656 185.613 176.019C185.577 176.16 185.624 176.312 185.659 176.453M189.281 197.237L189.656 197.178L189.281 197.237ZM188.918 197.295L189.047 197.272L188.918 197.295Z"
                                    stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M254.053 302.28C248.908 291.607 245.204 280.418 241.23 269.263C239.319 263.927 237.362 258.438 233.857 253.899C232.228 251.799 230.751 250.181 228.067 249.594C225.652 249.078 223.097 249.36 220.706 249.899C219.37 250.204 218.186 250.908 216.862 251.201C215.08 251.6 212.325 251.178 211.622 253.418C211.306 254.426 211.493 255.517 211.728 256.549C212.126 258.25 212.665 259.916 213.333 261.511C214.201 263.575 215.291 265.557 216.018 267.668C216.568 269.287 216.908 270.976 217.553 272.559C218.585 275.093 220.401 277.286 222.628 278.881C223.976 279.843 225.524 280.64 226.473 282.001C227.165 282.998 227.235 284.03 227.645 285.109C228.723 287.947 229.954 290.985 232.521 292.604C233.201 293.026 233.975 293.354 234.467 293.976C234.807 294.398 234.994 294.926 235.182 295.442C235.733 296.99 236.342 298.562 237.35 299.852C238.265 301.013 239.484 301.905 240.421 303.054C241.406 304.274 241.652 305.681 242.332 307.042C242.531 307.441 254.112 302.409 254.041 302.257L254.053 302.28Z"
                                    fill="black" />
                                <path
                                    d="M176.658 175.773L172.086 176.242C167.234 176.746 162.088 177.356 158.302 180.429C153.789 184.077 151.047 190.563 152.031 196.298C152.57 199.453 153.567 202.526 153.907 205.717C155.043 216.331 155.876 226.981 156.403 237.643C161.561 237.408 166.718 237.361 171.875 237.091C178.193 236.763 185.32 236.481 191.379 234.183C192.083 225.386 194.474 216.695 194.333 207.875L194.134 194.926"
                                    fill="white" />
                                <path
                                    d="M176.658 175.773L172.086 176.242C167.234 176.746 162.088 177.356 158.302 180.429C153.789 184.077 151.047 190.563 152.031 196.298C152.57 199.453 153.567 202.526 153.907 205.717C155.043 216.331 155.876 226.981 156.403 237.643C161.561 237.408 166.718 237.361 171.875 237.091C178.193 236.763 185.32 236.481 191.379 234.183C192.083 225.386 194.474 216.695 194.333 207.875L194.134 194.926"
                                    stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M231.97 278.975C232.087 278.717 232.205 278.471 232.322 278.213C232.545 277.697 232.72 277.169 232.861 276.629C234.525 270.319 236.729 263.47 236.038 256.655C235.44 250.709 235.487 243.132 229.708 239.507C224.914 236.505 218.221 234.534 214.06 239.519C213.181 240.563 212.595 241.83 212.232 243.143C209.688 252.386 213.931 260.338 212.712 268.994C212.407 271.164 212.103 273.392 212.536 275.538C212.677 276.254 212.911 276.958 213.005 277.673C213.24 279.444 212.665 281.215 212.196 282.939C211.692 284.769 211.306 286.657 211.388 288.558C211.47 290.504 212.056 292.416 212.079 294.375C212.091 295.806 211.81 297.225 211.517 298.633C211.142 300.439 209.383 304.11 211.728 304.849C213.169 305.306 214.845 305.212 216.346 305.6C216.838 305.729 220.46 306.655 222.312 307.288C222.863 307.476 223.414 307.101 223.496 306.526C223.836 303.957 225.066 301.26 225.746 298.832C226.637 295.63 227.469 292.416 228.231 289.179C228.595 287.631 228.958 286.071 229.45 284.546C230.095 282.564 231.079 280.793 231.947 278.952L231.97 278.975Z"
                                    fill="black" />
                                <path
                                    d="M188.519 163.505L186.703 152.479L179.6 154.133C175.099 155.177 172.297 159.681 173.34 164.197L173.962 166.894C174.22 167.985 174.7 168.959 175.345 169.78L173.915 176.465C173.188 179.608 175.251 182.716 178.416 183.291C181.592 183.866 184.593 181.673 185.027 178.471L186.152 170.823C188.156 169.064 189.164 166.284 188.508 163.505H188.519Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M190.43 221.844C193.782 222.583 196.209 223.943 199.162 225.527C201.706 226.899 202.21 229.409 198.822 230.031C196.982 230.359 195.083 230.699 193.255 230.3C191.426 229.902 190.782 228.776 189.551 227.544C188.496 226.488 186.703 227.004 185.179 226.348C184.581 226.09 183.995 225.703 183.772 225.093C183.561 224.495 183.772 223.838 184.007 223.24C184.218 222.712 184.452 222.16 184.874 221.773C185.706 221.011 186.996 221.07 188.098 221.328C188.871 221.504 189.656 221.68 190.442 221.844H190.43Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M187.089 154.309C185.917 155.224 184.487 155.822 183.022 156.068C181.663 156.303 180.268 156.291 178.955 156.714C175.427 157.828 175.907 161.733 176.212 164.713C176.318 165.756 175.38 169.299 173.915 168.736C172.954 168.736 172.801 167.305 172.579 166.695C172.145 165.51 171.664 164.349 171.207 163.164C170.891 162.343 170.562 161.499 170.633 160.619C170.727 159.341 171.641 158.262 171.91 157.019C172.121 156.057 171.934 155.048 172.098 154.075C172.309 152.761 173.165 151.588 174.278 150.861C175.931 149.77 177.888 150.192 179.553 149.277C180.467 148.773 181.147 147.929 181.979 147.307C183.245 146.38 184.886 146.005 186.433 146.287C187.746 146.533 189.035 147.33 189.504 148.585C189.938 149.735 189.61 151.049 189.012 152.128C188.531 152.984 187.875 153.723 187.113 154.321L187.089 154.309Z"
                                    fill="black" />
                                <path
                                    d="M175.392 166.273C176.693 166.273 177.748 165.217 177.748 163.915C177.748 162.613 176.693 161.558 175.392 161.558C174.09 161.558 173.036 162.613 173.036 163.915C173.036 165.217 174.09 166.273 175.392 166.273Z"
                                    fill="white" />
                                <path
                                    d="M152.019 191.278C151.457 196.075 151.351 200.931 151.07 205.752C150.765 211.018 151.011 216.355 152.488 221.445C152.957 223.04 153.555 224.635 154.633 225.902C158.56 230.476 168.242 228.599 173.575 228.599H186.761C186.832 228.388 186.878 228.177 186.949 227.978C187.3 226.172 188.461 221.891 188.789 220.073L180.42 219.392L173.188 218.806C171.254 218.653 168.3 219.099 167.972 216.531C167.855 215.627 167.984 214.677 167.632 213.845C167.105 212.601 165.604 211.909 165.264 210.607C165.007 209.622 165.44 208.414 165.511 207.417C165.616 205.939 166.308 204.579 166.894 203.218C167.902 200.884 168.64 198.445 169.086 195.946L168.664 195.923"
                                    fill="white" />
                                <path
                                    d="M152.019 191.278C151.457 196.075 151.351 200.931 151.07 205.752C150.765 211.018 151.011 216.355 152.488 221.445C152.957 223.04 153.555 224.635 154.633 225.902C158.56 230.476 168.242 228.599 173.575 228.599H186.761C186.832 228.388 186.878 228.177 186.949 227.978C187.3 226.172 188.461 221.891 188.789 220.073L180.42 219.392L173.188 218.806C171.254 218.653 168.3 219.099 167.972 216.531C167.855 215.627 167.984 214.677 167.632 213.845C167.105 212.601 165.604 211.909 165.264 210.607C165.007 209.622 165.44 208.414 165.511 207.417C165.616 205.939 166.308 204.579 166.894 203.218C167.902 200.884 168.64 198.445 169.086 195.946L168.664 195.923"
                                    stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M198.412 226.336H247.724V228.119H196.619C196.619 227.134 197.416 226.336 198.4 226.336H198.412Z"
                                    fill="url(#paint0_linear_28_2046)" />
                                <path
                                    d="M256.503 226.336H205.445L214.552 199.348C214.869 198.421 215.795 197.788 216.85 197.788H262.879C264.497 197.788 265.657 199.242 265.177 200.661L256.515 226.324L256.503 226.336Z"
                                    fill="url(#paint1_linear_28_2046)" />
                                <path
                                    d="M255.612 228.119H205.199V226.336L256.503 223.99V227.227C256.503 227.72 256.104 228.119 255.612 228.119Z"
                                    fill="url(#paint2_linear_28_2046)" />
                                <path
                                    d="M235.991 212.695C234.994 212.648 234.045 211.851 234.725 210.678C235.006 210.185 235.569 209.927 236.166 209.904C236.19 209.904 236.225 209.904 236.248 209.892C236.272 209.904 236.307 209.927 236.342 209.927C237.995 210.338 237.854 212.777 235.991 212.695Z"
                                    fill="#C9CDD1" />
                                <path
                                    d="M204.214 210.889C204.085 211.276 203.827 211.593 203.593 211.91C203.347 212.238 203.124 212.578 202.925 212.93C202.773 213.2 202.55 213.399 202.433 213.692"
                                    fill="white" />
                                <path
                                    d="M204.214 210.889C204.085 211.276 203.827 211.593 203.593 211.91C203.347 212.238 203.124 212.578 202.925 212.93C202.773 213.2 202.55 213.399 202.433 213.692"
                                    stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M180.479 170.647C182.038 172.583 184.112 174.072 185.519 176.125L186.011 172.196C186.105 171.48 186.339 170.835 186.503 170.167C184.417 170.647 182.671 171.199 180.479 170.659V170.647Z"
                                    fill="black" />
                                <path
                                    d="M182.917 165.698C182.987 166.366 183.538 166.929 184.194 167.07C184.851 167.211 185.554 166.953 186.011 166.46C186.468 165.968 186.679 165.276 186.644 164.607C186.609 164.595 186.55 164.642 186.574 164.677"
                                    fill="black" />
                                <path
                                    d="M175.732 163.059C175.345 162.977 174.911 163.106 174.653 163.411C174.395 163.716 174.337 164.173 174.524 164.525C174.712 164.877 175.157 165.076 175.532 164.971"
                                    fill="black" />
                                <path
                                    d="M212.021 275.609C211.821 273.193 212.067 270.753 212.747 268.431C213.251 266.695 213.849 265.158 213.439 263.387C213.029 261.616 212.771 260.232 213.439 258.438"
                                    stroke="white" stroke-miterlimit="10" />
                                <path
                                    d="M234.584 241.642C238.64 252.069 235.17 263.716 232.298 274.53C230.435 281.567 228.829 288.686 227.504 295.853"
                                    stroke="white" stroke-miterlimit="10" />
                                <path
                                    d="M156.79 222.829C156.708 223.251 156.79 223.721 157.013 224.084C157.142 224.283 157.306 224.471 157.505 224.588C157.986 224.87 158.595 224.8 159.158 224.717"
                                    fill="black" />
                                <path d="M183.046 200.707L183.185 200.591L183.046 200.707Z" fill="black" />
                                <path
                                    d="M290.835 86.6102C294.719 86.6102 297.867 83.4595 297.867 79.5729C297.867 75.6864 294.719 72.5356 290.835 72.5356C286.95 72.5356 283.802 75.6864 283.802 79.5729C283.802 83.4595 286.95 86.6102 290.835 86.6102Z"
                                    fill="black" />
                                <path
                                    d="M432.662 86.6102C436.546 86.6102 439.695 83.4595 439.695 79.5729C439.695 75.6864 436.546 72.5356 432.662 72.5356C428.778 72.5356 425.629 75.6864 425.629 79.5729C425.629 83.4595 428.778 86.6102 432.662 86.6102Z"
                                    fill="black" />
                                <path
                                    d="M149.007 86.6102C152.891 86.6102 156.04 83.4595 156.04 79.5729C156.04 75.6864 152.891 72.5356 149.007 72.5356C145.123 72.5356 141.974 75.6864 141.974 79.5729C141.974 83.4595 145.123 86.6102 149.007 86.6102Z"
                                    fill="black" />
                                <path
                                    d="M174.032 76.9926V76.7463C174.032 62.9883 162.885 51.8342 149.136 51.8342C135.387 51.8342 124.24 62.9883 124.24 76.7463V76.9926H174.032Z"
                                    fill="url(#paint3_linear_28_2046)" />
                                <path
                                    d="M457.312 76.9926V76.7463C457.312 62.9883 446.165 51.8342 432.416 51.8342C418.667 51.8342 407.52 62.9883 407.52 76.7463V76.9926H457.312Z"
                                    fill="url(#paint4_linear_28_2046)" />
                                <path d="M432.967 13V51.8459" stroke="black" stroke-width="2" stroke-miterlimit="10" />
                                <path
                                    d="M315.484 76.9926V76.7463C315.484 62.9883 304.337 51.8342 290.588 51.8342C276.839 51.8342 265.692 62.9883 265.692 76.7463V76.9926H315.484Z"
                                    fill="url(#paint5_linear_28_2046)" />
                                <path d="M291.139 13V51.8459" stroke="black" stroke-width="2" stroke-miterlimit="10" />
                                <path d="M150.238 13V51.8459" stroke="black" stroke-width="2" stroke-miterlimit="10" />
                                <path
                                    d="M397.943 212.015C397.943 213.211 398.037 213.727 396.994 214.185C395.951 214.642 394.31 214.513 393.173 214.724C390.688 215.182 388.203 215.897 386.058 217.293C382.378 219.674 377.994 220.143 374.161 222.583C373.516 222.993 372.883 223.427 372.157 223.638C371.242 223.908 370.281 223.791 369.332 223.767C366.589 223.673 363.659 224.342 361.736 226.301C361.08 226.969 360.541 228.001 360.986 228.822C361.221 229.245 361.666 229.514 362.112 229.714C365.452 231.227 368.957 230.23 372.192 228.998C374.899 227.954 378.263 227.743 381.159 227.532C385.976 227.18 390.852 227.45 395.611 226.453C398.166 225.925 400.745 225.269 403.077 224.084C405.222 223.005 407.883 221.926 408.915 219.568C409.114 219.111 409.231 218.63 409.36 218.149C410.251 214.631 411.142 211.1 412.032 207.581C412.712 204.896 412.63 202.081 412.56 199.313C412.501 196.99 412.091 194.668 411.364 192.463C410.825 190.821 410.298 188.722 409.36 187.279C408.422 185.813 406.793 184.816 405.058 184.64C401.577 184.288 398.272 186.552 398.506 190.235C398.787 194.738 397.299 199.172 398.295 203.641C398.412 204.18 398.565 204.708 398.565 205.259C398.565 205.799 398.436 206.315 398.319 206.843C397.967 208.555 397.955 210.267 397.943 212.015Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M386.562 292.51C387.969 294.598 388.965 296.592 388.59 299.383C388.039 303.488 384.698 306.209 383.808 310.197C383.726 310.561 383.667 310.936 383.761 311.323C383.948 312.074 384.687 312.66 385.402 312.848C389.27 313.868 392.657 308.168 394.849 305.975L403.113 297.659C403.851 296.92 403.746 295.583 402.89 294.703L393.665 285.168L392.306 283.749C390.055 281.403 386.691 281.133 384.851 283.174C383.257 284.933 383.386 287.936 385.003 290.305C385.542 291.079 386.058 291.818 386.539 292.533L386.562 292.51Z"
                                    fill="#110809" />
                                <path d="M417.366 299.371H419.417V254.075H417.366V299.371Z" fill="#110809" />
                                <path
                                    d="M436.331 308.872C436.331 302.186 424.504 299.383 418.596 299.371C411.564 299.36 400.862 301.952 400.862 308.872"
                                    stroke="#110809" stroke-width="2" stroke-miterlimit="10" />
                                <path d="M418.385 310.655V299.547" stroke="#110809" stroke-width="2"
                                    stroke-miterlimit="10" />
                                <path
                                    d="M400.85 313.399C402.456 313.399 403.757 312.097 403.757 310.49C403.757 308.884 402.456 307.582 400.85 307.582C399.245 307.582 397.943 308.884 397.943 310.49C397.943 312.097 399.245 313.399 400.85 313.399Z"
                                    fill="#110809" />
                                <path
                                    d="M418.444 313.399C420.049 313.399 421.351 312.097 421.351 310.49C421.351 308.884 420.049 307.582 418.444 307.582C416.839 307.582 415.537 308.884 415.537 310.49C415.537 312.097 416.839 313.399 418.444 313.399Z"
                                    fill="#110809" />
                                <path
                                    d="M436.026 313.399C437.631 313.399 438.933 312.097 438.933 310.49C438.933 308.884 437.631 307.582 436.026 307.582C434.421 307.582 433.119 308.884 433.119 310.49C433.119 312.097 434.421 313.399 436.026 313.399Z"
                                    fill="#110809" />
                                <path
                                    d="M420.378 238.874V205.552C420.378 199.782 425.055 195.114 430.81 195.114H442.297C448.064 195.114 452.729 199.794 452.729 205.552V242.803C452.729 251.037 446.001 257.769 437.772 257.769H400.311C399.338 257.769 398.553 256.983 398.553 256.01C398.553 255.036 399.338 254.251 400.311 254.251H405C413.486 254.251 420.366 247.366 420.366 238.874H420.378Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M383.433 303.101C382.987 305.576 382.331 307.711 380.115 309.458C376.869 312.027 372.567 311.651 369.168 313.903C368.863 314.103 368.558 314.337 368.359 314.677C367.972 315.346 368.101 316.273 368.488 316.918C370.563 320.343 376.951 318.607 380.057 318.548L391.778 318.313C392.821 318.302 393.677 317.27 393.677 316.038V300.814C393.712 297.565 391.473 295.032 388.731 295.208C386.363 295.36 384.359 297.612 383.89 300.427C383.737 301.354 383.608 302.245 383.444 303.101H383.433Z"
                                    fill="#110809" />
                                <path d="M405.152 219.592C405.152 219.592 405.176 219.498 405.187 219.451L405.152 219.592Z"
                                    fill="#7A483A" />
                                <path d="M412.994 182.271L412.841 182.998L412.994 182.271Z" fill="#7A483A" />
                                <path
                                    d="M405.269 219.041C405.246 219.181 405.211 219.322 405.176 219.451L405.281 218.923C405.281 218.923 405.281 219.005 405.269 219.041Z"
                                    fill="#7A483A" />
                                <path d="M397.451 190.551L398.682 180.324L397.475 190.563L397.451 190.551Z"
                                    fill="#7A483A" />
                                <path
                                    d="M399.045 180.429C399.959 177.72 401.518 175.175 404.144 173.861C404.929 173.462 405.773 173.193 406.605 172.911C408.75 172.207 410.895 171.504 413.122 171.175C413.497 171.117 414.001 171.163 414.084 171.527C414.119 171.668 414.072 171.82 414.037 171.961C413.908 172.547 414.224 173.052 414.142 173.638C414.037 174.389 413.755 175.14 413.568 175.878C413.181 177.391 412.794 178.963 412.958 180.535C413.204 182.892 411.962 184.874 411.962 187.138C411.88 187.513 410.802 192.815 410.766 192.815L397.463 190.563C397.873 187.126 397.955 183.666 399.045 180.429Z"
                                    fill="black" />
                                <path
                                    d="M365.874 246.357C365.722 245.055 365.874 243.613 366.39 242.029C367.351 239.062 370.223 237.068 373.212 236.212C376.201 235.355 379.365 235.426 382.471 235.308C388.695 235.086 394.931 233.115 401.12 233.385C402.726 233.455 404.308 233.901 405.914 233.831C410.145 233.666 413.627 230.089 417.858 229.808C419.241 229.714 420.624 229.995 421.949 230.394C424.117 231.051 426.239 232.095 427.716 233.819C430.611 237.197 430.353 242.334 428.688 246.463C428.02 248.128 427.141 249.735 425.887 251.025C424.141 252.843 421.808 253.91 419.44 254.685C416.721 255.576 414.459 255.517 411.622 255.494L392.669 255.341C388.027 255.306 383.397 255.904 378.756 255.529C373.024 255.06 366.542 252.128 365.874 246.357Z"
                                    fill="black" />
                                <path
                                    d="M370.551 237.666C372.837 235.907 375.591 235.074 378.791 236.223C380.397 236.798 381.803 237.865 382.929 239.144C388.602 245.583 389.715 256.233 391.391 264.302C392.364 269.005 393.22 273.732 393.958 278.482C394.169 279.843 396.549 291.947 395.763 292.346C394.99 292.733 381.944 293.941 382.061 294.234C379.553 287.713 376.599 281.192 374.56 274.518C373.411 270.741 371.536 267.258 369.988 263.645C368.195 259.446 366.624 254.708 365.769 250.216C364.807 245.125 366.437 240.821 370.551 237.678V237.666Z"
                                    fill="black" />
                                <path
                                    d="M405.515 247.143C405.363 247.342 405.211 247.553 405.082 247.776C401.097 254.121 411.786 255.658 415.643 255.67L429.204 255.693C437.057 255.693 443.153 251.752 443.399 243.999V220.542L426.614 220.589C423.261 220.589 419.546 220.155 416.229 220.612C413.849 220.941 414.154 220.401 413.169 222.747C411.939 225.691 412.572 230.359 412.032 233.561C411.353 237.631 410.028 241.712 407.414 244.903C406.793 245.665 406.102 246.369 405.504 247.143H405.515Z"
                                    fill="url(#paint6_linear_28_2046)" />
                                <path
                                    d="M393.337 266.718C392.47 266.39 391.344 264.889 390.395 265.111C389.516 265.323 388.731 266.965 388.355 267.692C387.336 269.662 386.761 271.902 385.285 273.615C385.144 273.779 384.992 273.932 384.792 274.014C384.359 274.178 383.89 273.896 383.55 273.591C380.713 271.058 380.514 265.968 380.315 262.414C379.998 256.526 383.046 250.579 388.016 247.413C389.668 246.357 391.485 245.606 393.267 244.821C399.069 242.252 404.648 239.202 409.946 235.707C412.243 234.194 414.412 233.162 416.955 232.177C421.281 230.488 425.969 229.972 430.564 230.711C436.143 231.614 441.746 232.752 443.516 240.68C444.887 246.85 442.508 252.526 438.358 254.039C438.265 254.075 438.171 254.098 438.077 254.133L399.561 267.012C399.479 267.047 399.409 267.082 399.327 267.117C399.127 267.187 398.916 267.246 398.694 267.305C396.9 267.715 395.013 267.387 393.325 266.73L393.337 266.718Z"
                                    fill="url(#paint7_linear_28_2046)" />
                                <path
                                    d="M406.148 176.406C406.523 175.491 407.016 174.659 407.707 174.002C411.271 170.682 416.897 170.823 421.433 170.671C424.387 170.577 427.352 170.612 430.271 171.093C433.377 171.609 435.733 172.817 438.499 174.189C440.058 174.963 441.64 175.761 442.895 176.969C445.79 179.749 446.399 184.124 446.481 188.147C446.563 192.158 443.082 233.139 443.293 233.139C438.136 232.904 432.978 232.857 427.821 232.587C425.184 232.447 422.546 232.329 419.909 232.071C418.467 231.93 417.026 232.095 415.584 231.93C413.978 231.755 414.142 231.074 413.04 230.382C412.49 230.03 412.009 230.312 411.634 229.843C411.329 229.456 411.482 227.954 411.446 227.438C411.341 225.726 411.271 224.002 411.095 222.289C410.895 220.366 410.391 218.524 410.251 216.554C409.887 211.698 409.7 206.796 408.668 202.01C407.743 197.729 406.148 193.612 405.293 189.32C404.707 186.376 404.484 183.279 405.082 180.312C405.34 179.045 405.609 177.638 406.125 176.371L406.148 176.406Z"
                                    fill="black" />
                                <path
                                    d="M424.996 164.161C425.641 163.329 425.477 163.493 425.735 162.402L428.255 151.541L412.994 147.987L411.177 159.012C410.532 161.792 411.528 164.572 413.533 166.331L414.658 173.978C415.08 177.18 418.092 179.374 421.269 178.799C424.445 178.224 426.497 175.116 425.77 171.973L424.984 164.161H424.996Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M414.424 168.231C416.24 168.161 418.139 167.352 418.655 165.498C418.632 165.604 418.28 165.698 418.186 165.745C417.295 166.085 416.276 166.061 415.338 165.968C414.717 165.909 414.072 165.839 413.545 165.51C413.498 165.475 413.439 165.44 413.38 165.452C413.322 165.452 413.275 165.498 413.251 165.557C413.087 165.815 413.169 166.284 413.369 166.507C413.556 166.718 413.732 166.847 413.802 167.14C413.873 167.434 413.884 167.727 413.92 168.02C413.931 168.114 414.166 168.184 414.412 168.243L414.424 168.231Z"
                                    fill="black" />
                                <path
                                    d="M412.22 150.333C413.275 150.685 414.424 150.943 415.514 151.224C417.084 151.635 418.678 151.952 420.237 152.409C424.387 153.629 423.449 157.746 423.461 161.217C423.461 162.179 423.543 163.282 424.328 163.833C426.508 165.334 427.036 160.666 427.575 159.587C427.868 159.012 428.302 158.496 428.548 157.898C429.04 156.655 428.606 155.247 428.782 153.91C428.864 153.312 429.063 152.726 429.11 152.116C429.321 149.582 427.001 147.26 424.926 146.24C423.261 145.43 421.492 144.293 420.46 142.697C420.296 142.439 420.144 142.158 419.909 141.97C419.733 141.818 419.511 141.724 419.288 141.642C418.057 141.22 416.615 141.454 415.572 142.252C415.244 142.498 414.951 142.803 414.576 142.956C413.99 143.19 413.334 143.026 412.712 142.991C411.786 142.932 410.825 143.167 410.145 143.788C409.465 144.41 409.149 145.454 409.512 146.31C409.735 146.826 410.157 147.213 410.391 147.717C410.931 148.867 410.673 149.782 411.974 150.239C412.056 150.274 412.15 150.298 412.232 150.333H412.22Z"
                                    fill="#110809" />
                                <path
                                    d="M423.414 161.593C424.307 161.593 425.031 160.868 425.031 159.974C425.031 159.08 424.307 158.355 423.414 158.355C422.52 158.355 421.796 159.08 421.796 159.974C421.796 160.868 422.52 161.593 423.414 161.593Z"
                                    fill="white" />
                                <path
                                    d="M385.683 250.837C384.265 253.078 383.386 255.67 382.741 258.238C381.721 262.296 380.713 266.495 381.323 270.636C381.499 271.844 381.827 273.04 381.897 274.272C382.026 276.453 381.346 278.611 381.37 280.793C381.381 282.353 381.756 283.889 382.073 285.426C382.847 289.261 383.081 292.967 382.94 296.861C382.893 298.116 382.847 299.371 382.776 300.615C382.729 301.612 382.893 303.042 382.413 303.91C383.89 304.133 385.378 304.321 386.855 304.52C389.61 304.896 392.376 305.271 395.154 305.47C396.01 305.529 397.873 305.998 398.612 305.435C399.233 304.954 399.315 303.488 399.491 302.808C400.757 297.706 401.858 292.357 400.827 287.103C400.639 286.153 400.393 285.215 400.288 284.265C400.159 283.068 400.264 281.86 400.428 280.664C401.097 275.714 402.304 270.87 402.949 265.921C403.617 260.713 404.074 255.459 404.472 250.227C405.187 240.95 392.47 243.964 388.191 247.835C387.207 248.726 386.375 249.747 385.683 250.849V250.837Z"
                                    fill="url(#paint8_linear_28_2046)" />
                                <path d="M347.284 135.707H346.897C346.897 135.707 347.284 135.66 347.284 135.707Z"
                                    fill="#110809" />
                                <path
                                    d="M428.782 181.532C427.129 183.103 424.574 184.3 422.652 185.555C420.988 184.065 418.995 182.951 416.862 182.318C415.666 181.966 414.435 181.755 413.263 181.332C407.965 179.397 403.886 175.398 398.424 173.627C395.693 172.735 392.645 172.09 390.77 169.908C388.461 167.234 388.016 163.223 386.316 160.185C385.648 158.989 384.593 157.969 383.21 159.27C382.143 160.267 382.518 162.226 382.741 163.493C383.081 165.416 383.479 167.316 383.89 169.228C384.476 172.008 384.792 172.981 387.301 174.354C389.809 175.726 392.294 177.415 394.24 179.503C395.505 180.851 396.537 182.4 397.744 183.784C402.011 188.686 408.235 191.443 412.97 195.9C415.256 198.046 417.682 200.978 421.14 200.028C422.265 199.723 435.44 196.228 435.018 195.477C433.412 192.627 432.263 189.977 431.08 186.962C430.365 185.144 429.403 183.408 428.77 181.567L428.782 181.532Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path d="M443.211 189.554C441.371 192.545 438.429 194.82 435.076 195.853L443.211 189.554Z"
                                    fill="black" />
                                <path d="M443.211 189.554C441.371 192.545 438.429 194.82 435.076 195.853" stroke="white"
                                    stroke-miterlimit="10" />
                                <path d="M338.505 143.46L338.481 143.589L338.505 143.46Z" fill="white" />
                                <path d="M338.505 143.46L338.481 143.589" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M393.267 217.305H335.821C334.824 217.305 333.969 216.613 333.758 215.639L326.619 182.575C326.338 181.262 327.334 180.019 328.682 180.019H386.128C387.125 180.019 387.98 180.711 388.191 181.684L395.33 214.748C395.611 216.061 394.615 217.305 393.267 217.305Z"
                                    fill="black" />
                                <path
                                    d="M361.889 226.711L363.026 213.106C363.131 211.815 362.123 210.713 360.822 210.713C359.674 210.713 358.724 211.593 358.619 212.73L357.446 226.711H349.16V228.118H370.41V226.711H361.865H361.889Z"
                                    fill="black" />
                                <path
                                    d="M352.078 187.584C351.914 186.188 349.699 186.165 349.863 187.584L350.39 192.146C350.554 193.542 352.77 193.565 352.606 192.146L352.078 187.584Z"
                                    fill="white" />
                                <path
                                    d="M356.509 187.584C356.345 186.188 354.129 186.165 354.293 187.584L354.821 192.146C354.985 193.542 357.2 193.565 357.036 192.146L356.509 187.584Z"
                                    fill="white" />
                                <path
                                    d="M360.928 187.584C360.764 186.188 358.548 186.165 358.712 187.584L359.24 192.146C359.404 193.542 361.619 193.565 361.455 192.146L360.928 187.584Z"
                                    fill="white" />
                                <path
                                    d="M365.358 187.584C365.194 186.188 362.979 186.165 363.143 187.584L363.67 192.146C363.835 193.542 366.05 193.565 365.886 192.146L365.358 187.584Z"
                                    fill="white" />
                                <path
                                    d="M369.789 187.584C369.625 186.188 367.41 186.165 367.574 187.584L368.101 192.146C368.265 193.542 370.48 193.565 370.316 192.146L369.789 187.584Z"
                                    fill="white" />
                                <path
                                    d="M406.805 217.61C406.957 218.618 406.969 219.803 406.207 220.483C405.773 220.87 405.176 220.999 404.601 221.128"
                                    fill="black" />
                                <path
                                    d="M417.999 195.982C418.139 196.721 418.76 197.354 419.499 197.506C420.237 197.659 421.058 197.342 421.492 196.721"
                                    fill="#110809" />
                                <path
                                    d="M280.567 149.582C280.883 149.465 281.164 149.23 281.317 148.926C281.399 148.926 280.485 149.582 280.567 149.582Z"
                                    fill="#110809" />
                                <path d="M476.124 228.001H118.532V231.954H476.124V228.001Z" fill="black" />
                                <path d="M472.409 321.938H469.689L447.431 228.764H450.162L472.409 321.938Z" fill="black" />
                                <path d="M447.782 321.938H445.063L422.816 228.764H425.535L447.782 321.938Z" fill="black" />
                                <path d="M123.22 321.938H125.94L148.187 228.764H145.467L123.22 321.938Z" fill="black" />
                                <path d="M147.847 321.938H150.566L172.813 228.764H170.094L147.847 321.938Z" fill="black" />
                                <path
                                    d="M336.899 267.469C335.704 261.792 325.483 262.238 320.864 261.44C314.605 260.35 308.334 259.306 302.087 258.18C300.68 257.933 299.11 257.722 297.832 258.508C297.129 258.942 296.625 259.634 296.156 260.303C294.304 262.989 292.71 265.921 292.218 269.029C291.725 272.137 292.487 275.445 294.761 277.427C296.824 279.221 299.79 279.702 302.614 280.066C304.326 280.289 305.967 280.687 307.655 280.969C308.627 281.133 309.612 281.016 310.432 281.579C312.882 283.232 312.214 287.173 311.569 289.719C310.925 292.264 310.163 294.668 310.784 296.979C310.948 297.6 311.218 298.198 311.323 298.844C311.441 299.641 311.3 300.486 311.159 301.307C310.397 305.646 308.874 310.291 310.538 314.396C310.737 314.877 310.983 315.346 311.077 315.874C311.147 316.308 311.089 316.753 311.042 317.199L310.034 326.019C310.034 326.019 320.091 326.488 320.864 326.5C322.025 326.512 324.58 326.958 325.635 326.312C327.264 325.316 327.604 320.448 327.885 318.654C328.284 316.108 328.448 313.528 328.94 311.006C329.819 306.444 331.718 302.128 332.539 297.565C332.949 295.29 332.797 292.885 333.254 290.633C333.641 288.745 334.121 286.845 334.449 284.91L336.782 270.964C336.958 269.909 337.134 268.841 336.981 267.809C336.969 267.704 336.946 267.598 336.923 267.504L336.899 267.469Z"
                                    fill="black" />
                                <path
                                    d="M334.93 293.648C334.637 294.41 334.344 295.184 334.051 295.946C333.301 297.893 332.551 299.876 332.445 301.952C332.34 304.039 332.902 306.104 332.949 308.203C333.019 311.757 331.214 314.83 331.179 318.29C331.179 319.58 331.531 320.835 331.625 322.125C331.718 323.427 331.543 324.729 331.367 326.019C331.085 328.107 330.792 330.195 330.511 332.282C330.277 333.995 329.749 335.144 331.707 335.332C336.887 335.836 341.857 335.039 347.015 334.699C347.226 334.687 347.46 334.663 347.612 334.511C347.73 334.394 347.776 334.229 347.812 334.077C349.675 326.84 351.445 319.85 352.348 312.437C352.43 311.78 352.512 311.1 352.793 310.49C353.145 309.716 353.801 309.13 354.329 308.461C355.653 306.819 355.688 305.107 356.251 303.207C356.814 301.307 357.458 299.582 357.868 297.659C358.841 293.108 359.814 288.557 360.775 284.007C361.572 280.23 362.522 276.864 360.517 273.263C359.873 272.102 358.841 271.199 357.81 270.354C348.784 263.035 337.333 258.766 325.729 258.391C321.38 258.25 315.93 257.968 314.301 253.934C313.691 252.409 313.832 250.708 313.586 249.09C312.871 244.363 305.533 243.261 301.712 244.492C296.566 246.158 294.949 252.55 294.386 257.933C293.917 262.343 293.612 266.882 294.878 271.128C296.765 277.462 302.04 282.4 308.088 285.05C312.847 287.138 318.028 287.9 323.174 288.205C327.112 288.44 330.992 287.689 334.883 287.255C337.649 286.939 337.216 287.725 336.337 290.023C335.868 291.231 335.399 292.44 334.942 293.659L334.93 293.648Z"
                                    fill="url(#paint9_linear_28_2046)" />
                                <path
                                    d="M300.329 176.277C300.469 176.957 300.61 177.649 300.727 178.341C300.962 179.702 301.091 181.262 300.176 182.294C299.649 182.892 298.84 183.185 298.301 183.784C297.504 184.652 297.445 185.965 297.621 187.126C297.832 188.522 297.844 189.754 297.926 191.114C298.008 192.58 298.641 193.929 298.582 195.43C298.465 198.257 296.402 200.134 293.671 199.946C292.053 199.829 290.225 199.618 289.252 198.316C288.772 197.682 288.584 196.885 288.408 196.111C287.072 190.293 285.747 184.206 287.248 178.424C287.799 176.289 288.502 173.767 289.78 171.926C290.694 170.6 291.714 168.865 292.991 167.868C294.175 166.941 295.968 166.601 297.176 167.504C297.984 168.102 298.36 169.111 298.676 170.061C299.344 172.102 299.907 174.178 300.352 176.277H300.329Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M315.109 200.392C315.461 198.257 316.668 196.228 318.567 195.114C320.607 193.906 322.716 192.744 324.955 191.912C325.248 191.806 325.541 191.701 325.846 191.595C331.695 189.507 337.849 188.217 343.604 185.871C349.968 183.268 356.099 180.171 362.346 177.298C366.554 175.362 370.598 173.275 374.302 170.483C377.443 168.114 376.458 163.375 377.959 160.127C378.603 158.731 379.822 157.276 380.959 159.177C382.003 160.936 381.71 163.282 381.956 165.24C382.214 167.187 382.471 169.158 381.604 171.011C380.995 172.313 379.904 173.31 378.838 174.272L375.743 177.051C374.56 178.119 373.387 179.256 372.133 180.206C368.195 183.185 364.397 186.352 360.752 189.683C357.107 193.014 353.872 196.357 349.734 199.031C345.749 201.623 341.166 203.828 336.594 205.048C336.524 205.071 336.442 205.083 336.372 205.107C331.8 206.35 327.628 208.215 322.728 207.71C318.919 207.312 314.406 204.813 315.144 200.403L315.109 200.392Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M312.331 247.588C312.331 247.729 299.801 248.363 298.653 248.445C296.39 248.585 293.484 249.277 291.256 248.902C289.838 248.656 289.229 247.154 287.553 247.471C286.545 247.659 285.349 248.022 284.611 247.319C284.13 246.861 284.071 246.134 284.036 245.477L283.251 231.321C283.04 227.427 278.234 226.359 275.433 224.576L269.713 220.952C273.288 213.223 278.269 206.526 284.13 200.403C289.991 194.281 294.644 193.413 303.634 193.319C310.901 193.249 318.157 192.287 325.201 190.457C326.877 196.427 328.659 202.456 330.277 208.391C326.151 210.631 321.134 212.249 316.645 213.751C315.309 214.255 313.879 214.842 313.152 216.073C312.589 217.035 312.554 218.208 312.554 219.322C312.484 228.74 312.413 238.17 312.343 247.588H312.331Z"
                                    fill="black" />
                                <path d="M468.717 384.312H447.278" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M452.459 330.406C452.459 330.195 452.494 329.984 452.529 329.773C452.905 327.474 454.721 325.714 455.964 323.732C457.171 321.809 457.863 319.568 457.956 317.305C458.132 313.047 458.015 307.593 459.844 303.664C461.496 300.11 465.411 298.187 467.427 294.856C468.541 293.014 468.881 290.833 469.373 288.733C470.158 285.402 471.424 282.107 473.651 279.503C475.386 277.485 477.636 275.972 479.852 274.495C482.009 273.052 484.189 271.597 486.627 270.741C489.838 269.604 493.39 269.228 494.878 272.536C496.074 275.21 495.476 278.987 494.21 281.508C493.109 283.69 491.362 285.473 489.721 287.291C486.873 290.446 484.271 293.812 481.926 297.354C481.27 298.339 480.625 299.395 480.485 300.568C480.344 301.705 480.684 302.843 480.836 303.993C481.563 309.787 479.184 314.466 474.718 317.985C471.19 320.765 468.986 322.348 468.095 327.169C467.544 330.148 467.298 333.315 465.646 335.86C464.966 336.892 464.087 337.783 463.278 338.722C460.301 342.217 458.449 346.65 458.039 351.225C457.839 353.512 457.347 358.672 453.678 357.64C449.177 356.374 449.728 343.225 451.041 340.117C451.604 338.792 452.447 337.572 452.705 336.153C453.057 334.265 452.33 332.318 452.436 330.406H452.459Z"
                                    fill="black" />
                                <path
                                    d="M434.139 338.053C433.178 337.361 432.334 336.575 431.818 335.508C430.447 332.623 432.568 330.652 432.721 327.943C432.861 325.492 430.751 323.943 429.403 322.231C427.716 320.085 427.329 316.988 428.431 314.49C428.923 313.387 429.685 312.308 429.521 311.112C429.403 310.244 428.794 309.529 428.337 308.778C427.047 306.632 426.977 303.805 428.173 301.588C428.841 300.345 429.896 299.266 430.177 297.87C430.365 296.944 430.2 295.982 430.025 295.044C429.462 292.017 428.935 288.956 429.122 285.883C429.204 284.546 429.45 283.162 430.224 282.06C430.915 281.074 432.111 280.265 433.365 280.594C434.619 280.922 434.842 281.978 435.311 283.033C436.647 286.083 436.999 288.815 437.585 292.088C437.69 292.663 437.819 293.249 438.159 293.718C438.523 294.246 439.097 294.574 439.636 294.926C443.094 297.166 445.919 300.873 445.895 305.001C445.895 307.417 444.911 309.751 444.875 312.168C444.875 312.789 444.934 313.446 445.309 313.939C445.649 314.396 446.2 314.631 446.704 314.889C448.204 315.651 449.623 316.73 450.349 318.255C451.158 319.979 450.959 322.02 450.384 323.838C449.81 325.656 448.896 327.356 448.286 329.163C448.134 329.608 448.005 330.078 448.052 330.558C448.157 331.684 449.083 332.224 449.693 333.057C450.338 333.948 450.396 334.534 450.736 335.531C451.639 338.182 452.576 340.364 452.143 343.261C451.967 344.41 451.627 345.536 451.51 346.697C451.264 349.008 451.885 351.307 452.236 353.606C452.471 355.13 453.045 358.696 451.475 359.752C450.127 360.655 448.216 359.165 447.079 358.508C443.528 356.444 441.019 354.778 440.457 350.521C440.058 347.495 440.457 344 438.452 341.443C437.327 340 435.592 339.12 434.115 338.053H434.139Z"
                                    fill="url(#paint10_linear_28_2046)" />
                                <path
                                    d="M457.558 339.918C458.425 337.643 459.597 335.496 461.051 333.549C462.106 332.13 463.313 330.816 464.251 329.327C465.763 326.934 466.548 324.143 468.013 321.715C470.252 317.997 474.73 315.874 478.82 317.997C480.262 318.748 481.481 319.838 482.677 320.929C484.013 322.149 485.337 323.404 486.451 324.835C488.678 327.708 489.956 331.192 491.198 334.617L495.593 346.733C496.285 348.656 497.926 353.031 496.32 354.931C494.761 356.772 491.35 354.122 490.635 352.585C490.166 351.588 489.463 350.697 488.596 350.017C487.482 349.16 486.064 348.586 485.384 347.366C484.669 346.087 484.798 344.199 483.497 343.542C483.122 343.355 482.688 343.308 482.29 343.167C481.176 342.78 480.461 341.713 479.852 340.692C478.469 338.382 477.414 335.778 475.937 333.549C474.999 333.831 474.167 336.669 473.522 337.572C472.596 338.886 471.436 340.035 470.123 340.962C468.107 342.358 465.657 343.319 464.321 345.384C463.583 346.533 463.29 347.894 462.891 349.196C462.328 351.06 460.559 356.456 457.675 355.541C455.694 354.919 455.788 351.577 455.765 349.993C455.706 346.568 456.315 343.12 457.534 339.918H457.558Z"
                                    fill="url(#paint11_linear_28_2046)" />
                                <path
                                    d="M472.737 351.283H430.915V356.514H434.268L436.987 371.961C438.253 379.163 444.512 384.405 451.815 384.405C459.117 384.405 465.376 379.151 466.642 371.961L469.361 356.514H472.714V351.283H472.737Z"
                                    fill="black" />
                                <path d="M433.096 356.948H470.557" stroke="white" stroke-miterlimit="10" />
                                <path
                                    d="M299.473 259.165L309.589 260.385C315.648 261.112 322.224 262.097 326.409 266.542C329.022 269.31 330.323 273.122 330.722 276.911C331.121 280.699 330.699 284.523 330.265 288.311"
                                    stroke="white" stroke-width="2" stroke-miterlimit="10" />
                                <path d="M292.522 286.786H290.471V332.083H292.522V286.786Z" fill="#110809" />
                                <path
                                    d="M273.557 341.583C273.557 334.898 285.384 332.095 291.292 332.083C298.324 332.071 309.026 334.663 309.026 341.583"
                                    stroke="#110809" stroke-width="2" stroke-miterlimit="10" />
                                <path d="M291.491 343.366V332.259" stroke="#110809" stroke-width="2"
                                    stroke-miterlimit="10" />
                                <path
                                    d="M309.026 346.099C310.631 346.099 311.933 344.796 311.933 343.19C311.933 341.584 310.631 340.281 309.026 340.281C307.42 340.281 306.119 341.584 306.119 343.19C306.119 344.796 307.42 346.099 309.026 346.099Z"
                                    fill="#110809" />
                                <path
                                    d="M291.444 346.099C293.049 346.099 294.351 344.796 294.351 343.19C294.351 341.584 293.049 340.281 291.444 340.281C289.839 340.281 288.537 341.584 288.537 343.19C288.537 344.796 289.839 346.099 291.444 346.099Z"
                                    fill="#110809" />
                                <path
                                    d="M273.85 346.099C275.456 346.099 276.757 344.796 276.757 343.19C276.757 341.584 275.456 340.281 273.85 340.281C272.245 340.281 270.943 341.584 270.943 343.19C270.943 344.796 272.245 346.099 273.85 346.099Z"
                                    fill="#110809" />
                                <path
                                    d="M305.416 269.721V230.828C305.416 224.096 299.25 218.642 291.643 218.642H276.476C268.869 218.642 262.703 224.096 262.703 230.828V274.307C262.703 283.913 271.588 291.771 282.43 291.771H331.882C333.16 291.771 334.203 290.856 334.203 289.718C334.203 288.581 333.16 287.666 331.882 287.666H325.694C314.5 287.666 305.416 279.632 305.416 269.721Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M279.16 165.369C277.097 165.475 275.022 165.581 273.124 166.261C269.361 167.598 267.638 170.413 265.728 173.556C263.817 176.699 260.57 178.635 258.156 181.344C253.678 186.387 253.08 194.48 256.784 200.122C258.003 201.975 259.621 203.559 261.391 204.907C271.248 212.367 287.33 207.042 293.062 196.556C296.086 191.02 294.937 184.229 293.706 178.048C293.026 174.647 293.425 171.961 296.953 170.202C297.867 169.744 298.864 169.463 299.707 168.912C301.77 167.551 302.497 164.607 301.559 162.32C300.622 160.033 298.277 158.473 295.816 158.203C294.749 158.086 293.648 158.191 292.663 158.602C290.319 159.587 289.006 162.085 286.92 163.54C284.681 165.088 281.938 165.24 279.16 165.381V165.369Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M344.108 197.365C343.99 197.424 344.026 197.588 344.108 197.706C344.53 198.386 345.385 198.714 346.182 198.656C346.979 198.597 347.718 198.175 348.316 197.659"
                                    fill="black" />
                                <path
                                    d="M108.229 331.027C111.1 330.746 114.16 331.027 117.231 331.837C117.207 326.746 117.067 321.609 116.809 316.46C116.633 313.071 115.367 309.951 111.464 309.282C109.096 308.883 107.268 309.681 106.541 311.651C104.771 316.413 106.998 325.597 108.24 331.027H108.229Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M96.3082 290.434C96.6598 293.695 96.0972 297.389 95.9683 300.708C95.8276 304.509 97.6092 307.406 98.0429 311.041C98.4415 314.408 98.4766 318.044 98.3946 321.551C98.3946 321.703 98.5118 321.82 98.6642 321.82H120.77C120.911 321.82 121.028 321.715 121.04 321.574C121.263 319.299 121.462 317.316 121.462 317.316C121.779 314.068 121.861 311.405 120.958 308.32C120.571 307.018 120.266 305.67 120.009 304.286C119.61 302.128 119.34 299.923 119.13 297.8C118.813 294.539 118.813 291.255 118.532 287.994C118.262 284.816 117.711 281.661 117.172 278.517C115.531 268.982 113.867 259.446 111.593 250.04C110.444 245.313 109.143 240.622 107.596 236C105.767 230.523 103.482 225.245 100.551 220.249C98.7814 217.234 96.6833 213.95 93.1552 212.848C90.3772 211.98 87.2476 211.581 84.4814 212.742C80.7541 214.302 77.8706 217.363 74.7996 219.885C74.3777 221.937 73.9557 223.99 73.5455 226.043C72.5492 230.91 73.8619 236.516 76.2062 240.809C77.0853 242.404 78.1402 243.917 78.8435 245.595C79.8984 248.105 80.0977 250.884 80.9064 253.488C81.7035 256.057 83.0631 258.391 84.3642 260.748C89.252 269.639 95.2064 280.195 96.2965 290.446L96.3082 290.434Z"
                                    fill="black" />
                                <path
                                    d="M128.483 215.276C128.964 217.41 128.624 220.108 129.995 221.984C131.343 223.826 135.492 224.459 137.591 225.222C138.048 225.386 138.528 225.562 138.845 225.937C139.63 226.84 138.927 228.377 137.837 228.846C136.747 229.315 135.481 229.069 134.309 228.811L126.045 226.981C125.482 226.852 124.908 226.723 124.404 226.441C122.998 225.644 122.505 223.885 122.294 222.278C120.759 210.854 110.057 203.289 106.424 192.592C105.498 189.847 104.923 186.997 104.361 184.159C103.528 180.019 102.767 175.855 101.876 171.726C101.243 168.759 99.5667 166.108 101.348 163.153C102.708 160.889 105.802 159.904 108.287 160.819C112.261 162.296 113.644 166.73 114.863 170.295C116.574 175.269 117.993 179.796 117.7 185.156C117.617 186.575 117.453 188.041 117.946 189.378C118.485 190.868 119.762 191.947 120.782 193.167C124.217 197.272 124.756 202.784 125.998 207.793C126.619 210.314 127.85 212.66 128.46 215.135C128.471 215.182 128.483 215.229 128.495 215.276H128.483Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M68.1654 335.871C71.1074 335.602 74.0964 335.871 76.9446 336.657C78.2574 331.766 79.4647 326.852 80.5548 321.902C81.2698 318.642 80.8244 315.651 77.097 315.018C74.8348 314.63 72.7953 315.393 71.5529 317.281C68.5405 321.855 68.3529 330.652 68.1654 335.871Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M91.8189 342.029C89.7325 343.378 87.1656 343.507 84.7627 343.448C84.5166 343.448 84.2821 343.448 84.036 343.437C80.2735 343.437 76.5109 343.296 72.7484 343.026C71.2129 342.921 69.4665 342.768 68.1771 341.83C66.6651 340.739 66.8878 338.874 67.2511 337.232C67.5676 335.825 67.7669 334.382 67.8255 332.951C69.5719 333.491 71.5646 334.054 73.3931 333.878C74.4128 333.772 75.4326 333.514 76.3703 333.092C76.8391 332.881 77.2845 332.623 77.7065 332.329C77.9292 332.165 78.5622 331.426 78.8318 331.485C79.0779 331.544 79.242 332.2 79.3592 332.388C79.6405 332.834 80.0156 333.244 80.4024 333.608C81.1526 334.312 82.0434 334.875 83.0162 335.215C83.9071 335.531 84.8448 335.684 85.7708 335.848C87.0953 336.083 88.408 336.376 89.6974 336.704C90.5061 336.904 91.3149 337.138 92.0065 337.596C92.698 338.053 93.2606 338.792 93.2958 339.625C93.3427 340.54 92.7566 341.396 91.9947 341.924C91.9361 341.971 91.8658 342.006 91.8072 342.053L91.8189 342.029Z"
                                    fill="black" />
                                <path
                                    d="M130.816 336.306C130.593 337.361 129.327 338.159 128.178 338.499C123.126 340 117.7 338.558 112.448 338.991C111.159 339.097 109.835 339.32 108.569 338.991C105.685 338.264 105.767 334.687 106.447 332.365C106.764 331.297 107.291 330.195 106.998 329.128C109.319 329.608 111.733 329.667 114.078 329.303C114.957 329.163 115.859 328.952 116.586 328.436C116.902 328.213 117.254 327.919 117.617 328.037C117.864 328.119 118.004 328.353 118.133 328.576C119.235 330.371 120.782 331.051 122.576 331.954C123.337 332.341 123.924 332.74 124.779 332.975C125.822 333.256 126.889 333.455 127.944 333.69C129.139 333.948 130.569 334.417 130.827 335.614C130.874 335.848 130.874 336.083 130.827 336.306H130.816Z"
                                    fill="url(#paint12_linear_28_2046)" />
                                <path
                                    d="M94.55 258.543C93.9991 253.148 93.8116 247.741 93.5537 242.287C93.2958 237.08 92.6277 231.977 91.8189 226.84C91.5142 224.94 91.7603 223.263 91.1508 221.386C90.3655 218.982 89.4044 216.613 88.0916 214.455C86.181 211.288 83.4148 208.532 79.9101 207.288C77.5307 206.444 74.8817 206.444 72.7133 207.746C70.5448 209.048 69.4196 211.124 68.3529 213.293L66.4307 217.187C65.0358 220.026 63.6293 222.888 62.7736 225.937C61.918 228.987 61.6601 232.271 62.5509 235.308C63.1253 237.255 64.2271 238.323 65.1413 240.012C66.2783 242.099 66.9581 244.469 67.0519 246.85C67.1105 248.574 66.8761 250.286 66.8057 251.999C66.6651 255.857 67.4152 259.693 68.435 263.422C68.8335 264.9 69.2906 266.378 69.361 267.903C69.4196 269.158 69.2203 270.413 69.1383 271.668C68.9273 275.069 69.5837 278.435 69.7595 281.825C69.9353 285.215 69.2438 288.1 67.9427 291.267C67.1105 293.296 66.6768 295.489 66.6651 297.682C66.6534 301.037 67.2043 304.45 66.208 307.722C65.9032 308.708 65.4578 309.646 65.071 310.608C63.3948 314.713 62.715 319.146 62.0703 323.544C62.0352 323.779 62.1993 323.99 62.4337 324.025C63.9809 324.225 69.1969 325.269 69.6775 325.327C74.4597 325.89 78.8669 324.26 83.5203 325.351C83.7313 325.398 83.9422 325.292 84.0126 325.093C87.5993 315.123 90.3538 305.048 92.2761 294.645C92.827 291.654 92.4284 288.815 92.5574 285.871C92.6043 284.804 92.9442 283.08 93.2372 282.06C94.9368 276.195 96.2847 270.636 95.2884 264.502C94.972 262.531 94.7258 260.561 94.5266 258.59L94.55 258.543Z"
                                    fill="url(#paint13_linear_28_2046)" />
                                <path
                                    d="M101.841 158.602C99.637 156.655 96.8474 155.318 94.0225 154.778C92.9911 154.579 91.9127 154.497 90.9047 154.802C90.2248 155.013 89.627 155.4 89.0293 155.775C84.7158 158.508 81.0354 162.179 78.8669 166.883C77.097 170.73 76.1827 174.905 75.4091 179.069C74.952 181.508 70.5448 211.241 69.0914 210.819C70.8144 211.323 72.5843 211.687 74.2722 212.332C76.6985 213.247 79.1248 214.197 81.5042 215.217C86.2865 217.258 90.9164 219.416 95.9683 220.648C96.6247 220.131 97.1638 219.533 97.5975 218.618C98.7814 216.05 99.6722 213.118 100.106 210.326C101.7 200.028 102.45 189.015 105.099 178.952C106.306 174.366 107.15 169.24 105.779 164.595C105.087 162.261 103.669 160.221 101.841 158.614V158.602Z"
                                    fill="black" />
                                <path
                                    d="M98.5587 214.795C99.8363 215.37 101.149 215.932 102.462 216.542C108.522 219.346 114.265 222.841 119.528 226.946C117.981 228.4 116.598 230.23 116.469 232.353C116.34 234.476 117.981 236.775 120.091 236.681C121.31 235.309 121.474 233.303 122.365 231.684C123.525 229.585 126.971 229.655 127.745 228.084C128.565 226.418 126.701 224.178 125.775 222.993C123.138 219.604 119.047 217.645 116.398 214.314C115.449 213.129 114.769 211.745 113.925 210.49C112.566 208.461 110.772 206.714 108.698 205.412C104.642 202.855 103.2 199.254 101.219 195.02C100.61 193.718 99.9887 192.404 99.6487 190.997C99.2033 189.202 99.2151 187.326 98.9338 185.484C98.5235 182.869 97.5272 180.382 96.3902 177.99C95.3588 175.82 94.1749 173.662 92.4167 172.031C90.6585 170.401 88.2205 169.346 85.8528 169.744C82.9108 170.237 80.6954 172.888 79.8515 175.738C79.0076 178.588 79.2654 181.661 79.6054 184.617C79.9336 187.467 80.3672 190.375 81.7035 192.909C82.9928 195.348 84.8682 197.424 86.2279 199.817C87.5876 202.21 88.2205 204.567 89.3575 206.936C91.3735 211.147 94.7727 213.082 98.5469 214.807L98.5587 214.795Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M96.8005 156.983C96.1792 157.781 95.7221 158.731 95.4525 159.716C94.0577 164.853 96.0386 171.175 98.1836 175.832C98.9689 177.544 99.2971 180.429 101.196 181.332C102.497 181.942 103.435 180.98 104.513 180.441C105.791 179.796 107.15 179.256 108.44 178.588C111.335 177.086 114.16 175.491 116.938 173.779C115.437 166.765 112.073 159.622 105.814 156.127C103.81 155.001 101.372 154.309 99.2268 155.13C98.2539 155.505 97.4334 156.174 96.7887 156.995L96.8005 156.983Z"
                                    fill="black" />
                                <path
                                    d="M89.1348 152.081C89.7091 150.251 90.1545 148.363 90.3421 146.31C90.5531 144.035 90.5531 141.677 91.3853 139.554C92.6746 136.258 97.2811 134.124 100.645 134.933C105.392 136.071 103.962 144.046 103.529 147.6C103.318 149.336 102.005 150.568 101.079 151.998C99.5433 154.391 99.3323 158.332 99.0979 161.135C99.0744 161.452 99.0393 161.804 98.84 162.05C98.6056 162.343 98.2188 162.449 97.8437 162.519C95.9331 162.941 93.9991 163.364 92.0299 163.329C89.4513 163.282 85.3957 162.39 86.603 159.048C87.4704 156.631 88.3963 154.391 89.1231 152.057L89.1348 152.081Z"
                                    fill="white" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M102.181 129.057C100.751 128.963 99.2854 129.421 98.2188 130.394C97.7616 130.805 97.3631 131.309 96.7888 131.543C96.5075 131.661 96.191 131.696 95.8862 131.743C93.1083 132.2 90.5531 133.913 89.0879 136.317C88.7597 136.857 88.4784 137.431 88.3963 138.053C88.3377 138.546 88.3963 139.05 88.4784 139.543C88.6542 140.692 88.8769 141.83 89.1348 142.967C89.252 143.472 89.4395 143.988 89.463 144.504C89.4747 144.938 89.4161 145.337 89.545 145.771C90.0608 147.518 91.7486 146.709 92.4519 145.571C93.0262 144.645 93.3662 143.601 93.7647 142.592C94.2687 141.302 94.8899 140 95.9917 139.167C97.0466 138.37 98.4063 138.112 99.7074 137.9C101.114 137.678 103.071 137.49 104.091 136.411C105.216 135.226 106.072 133.643 105.943 131.977C105.908 131.567 105.814 131.156 105.615 130.805C105.38 130.406 105.017 130.101 104.63 129.854C103.892 129.385 103.036 129.127 102.169 129.069L102.181 129.057Z"
                                    fill="black" />
                                <path
                                    d="M95.3119 142.076C94.7962 141.056 93.5771 140.669 92.5574 141.196C91.397 141.794 90.7523 143.448 90.9985 144.703C91.2212 145.817 92.3581 146.615 93.3662 145.982C93.835 145.853 94.2687 145.595 94.5969 145.254C95.3822 144.422 95.8628 143.155 95.3119 142.064V142.076Z"
                                    fill="white" />
                                <path
                                    d="M93.4247 143.378C93.2958 142.803 92.4988 143.061 92.5691 143.612C92.6277 144.07 92.6277 144.457 92.9324 144.809C93.12 145.02 93.4365 144.879 93.5185 144.656C93.6826 144.234 93.5185 143.8 93.413 143.378H93.4247Z"
                                    fill="black" />
                                <path
                                    d="M93.1317 206.596C92.9911 206.936 92.9676 207.335 93.0731 207.699C93.2489 208.285 93.7412 208.731 94.2921 208.965C94.4211 209.024 94.5617 209.071 94.6907 209.071C95.0306 209.094 95.3471 208.918 95.6401 208.754"
                                    fill="black" />
                                <path
                                    d="M77.0267 176.359C76.8509 177.286 76.7923 178.283 76.8392 179.362C77.0267 183.432 77.9644 187.42 78.8904 191.372C81.1174 189.238 84.1884 188.252 87.1422 187.349L96.484 184.476C97.3748 184.206 98.3829 183.795 98.629 182.904C98.7111 182.599 98.6876 182.271 98.6525 181.954C98.0312 176.113 93.7413 165.393 86.1927 166.73C83.9071 167.129 81.9848 168.677 80.379 170.342C78.5505 172.231 77.4487 174.119 77.0267 176.371V176.359Z"
                                    fill="black" />
                                <path
                                    d="M92.0416 168.442C91.8541 168.302 91.6548 168.595 91.8072 168.747C93.5537 170.647 95.0657 172.606 96.1792 174.952C97.3983 177.544 98.0078 180.336 99.051 182.986C99.133 183.209 99.4495 183.127 99.4026 182.892C98.5352 177.814 96.3316 171.644 92.0533 168.442H92.0416Z"
                                    fill="white" />
                                <path
                                    d="M97.328 149.758C97.4452 149.946 97.621 150.333 97.6679 150.427C97.8554 150.837 98.0195 151.248 98.1836 151.67C98.8283 153.371 99.473 155.13 99.4495 156.948C99.4612 155.67 100.141 154.637 100.551 153.476C100.962 152.315 101.688 151.236 102.356 150.169C102.661 149.7 102.884 148.796 102.11 149.395C101.665 149.735 101.137 149.922 100.586 150.005C99.473 150.157 98.336 149.887 97.2459 149.664C97.2694 149.664 97.2928 149.711 97.328 149.758Z"
                                    fill="black" />
                                <path
                                    d="M99.2385 144.844C99.1799 145.032 99.2737 145.219 99.3675 145.384C99.5667 145.712 99.8363 146.005 100.165 146.193C100.493 146.38 100.915 146.439 101.278 146.322C101.747 146.158 102.075 145.712 102.263 145.255C102.298 145.161 102.321 145.02 102.227 144.985"
                                    fill="black" />
                                <path
                                    d="M148.679 341.736C148.808 339.93 148.948 338.417 148.96 337.537C148.972 335.895 148.995 334.241 148.726 332.611C148.351 330.347 147.425 328.224 146.628 326.078C144.858 321.316 143.662 316.12 144.752 311.159C145.491 307.816 147.214 304.755 147.917 301.412C148.421 298.984 148.374 296.474 148.819 294.046C149.183 292.064 151.715 285.496 154.797 287.924C155.313 288.334 155.594 288.968 155.829 289.589C156.696 291.888 157.212 294.34 158.384 296.498C159.638 298.808 161.619 300.708 162.592 303.148C163.541 305.505 163.459 308.133 163.19 310.654C162.217 319.428 159.275 327.825 160.494 336.821C160.705 338.346 161.139 350.814 158.9 350.814C158.138 352.843 156.907 355.986 154.516 356.514C148.022 357.933 148.233 348.058 148.679 341.748V341.736Z"
                                    fill="url(#paint14_linear_28_2046)" />
                                <path
                                    d="M126.221 357.018C123.677 359.423 121.779 362.425 117.993 363.047C113.245 363.821 110.819 359.317 112.519 355.13C113.632 352.374 115.965 350.345 117.993 348.163C120.243 345.735 122.189 343.014 123.759 340.082C124.932 337.9 125.963 335.519 127.967 334.053C129.268 333.103 130.863 332.634 132.421 332.2C135.492 331.32 138.798 330.453 141.834 331.473C143.732 332.106 145.315 333.432 146.733 334.827C155.008 343.108 154.399 353.84 152.477 364.513C152.301 365.487 152.043 366.589 151.175 367.047C149.769 367.797 148.198 366.249 147.706 364.736C146.51 361.077 147.237 357.839 144.834 354.602C142.889 351.975 139.372 349.887 138.306 346.767C137.977 345.817 137.837 344.762 137.204 343.988C136.571 343.214 135.164 342.944 134.637 343.8C134.355 344.246 134.426 344.82 134.473 345.348C134.719 348.703 133.125 352.127 130.405 354.098C129.292 354.907 128.003 355.482 126.948 356.373C126.701 356.584 126.467 356.796 126.233 357.018H126.221Z"
                                    fill="black" />
                                <path
                                    d="M153.531 346.04C153.52 345.559 153.531 345.078 153.578 344.598C154.141 339.542 161.162 338.827 164.643 336.575C167.96 334.417 170.012 329.913 174.29 334.335C176.341 336.458 177.736 340.305 178.146 343.178C178.955 348.726 179.729 354.286 180.467 359.845C180.631 361.088 180.783 362.414 180.209 363.528C179.154 365.592 176.025 365.768 174.161 364.396C171.547 362.789 170.598 358.426 169.59 355.81C169.109 354.567 168.628 353.289 168.722 351.963C168.839 350.333 169.812 348.785 169.554 347.178C169.472 346.674 169.121 346.099 168.617 346.157C168.453 346.181 168.312 346.263 168.171 346.357C165.874 347.846 165.1 350.18 163.682 352.35C162.193 354.637 161.021 354.368 159.298 355.951C155.723 359.223 156.802 366.613 155.512 371.011C155.184 372.137 154.082 373.474 153.109 372.817C152.723 372.559 152.57 372.055 152.465 371.597C151.281 366.695 151.293 361.511 152.5 356.62C153.016 354.555 153.742 352.503 153.801 350.38C153.836 348.937 153.567 347.495 153.52 346.064L153.531 346.04Z"
                                    fill="url(#paint15_linear_28_2046)" />
                                <path
                                    d="M169.191 362.05H134.906V366.343H137.661L139.9 379.01C140.943 384.91 146.065 389.214 152.055 389.214C158.044 389.214 163.166 384.91 164.21 379.01L166.448 366.343H169.203V362.05H169.191Z"
                                    fill="black" />
                                <path d="M136.688 366.695H167.398" stroke="white" stroke-miterlimit="10" />
                                <path d="M144.846 389.414H177.15" stroke="black" stroke-miterlimit="10" />
                                <path
                                    d="M423.554 159.282C423.812 159.247 424.094 159.376 424.234 159.611C424.375 159.845 424.363 160.15 424.199 160.361C424.07 160.537 423.871 160.643 423.66 160.713C423.636 160.713 423.613 160.713 423.613 160.701"
                                    fill="black" />
                                <path
                                    d="M412.431 160.983C412.372 161.194 412.478 161.405 412.595 161.581C412.794 161.874 413.076 162.144 413.404 162.285C413.802 162.461 414.271 162.449 414.67 162.285C415.068 162.12 415.396 161.792 415.584 161.393H415.514"
                                    fill="black" />
                            </g>
                            <defs>
                                <linearGradient id="paint0_linear_28_2046" x1="196.619" y1="226.336" x2="196.868"
                                    y2="230.437" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint1_linear_28_2046" x1="205.445" y1="197.788" x2="237.84"
                                    y2="236.792" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint2_linear_28_2046" x1="205.199" y1="223.99" x2="206.508"
                                    y2="233.338" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint3_linear_28_2046" x1="124.24" y1="51.8342" x2="153.045"
                                    y2="84.5796" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint4_linear_28_2046" x1="407.52" y1="51.8342" x2="436.325"
                                    y2="84.5796" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint5_linear_28_2046" x1="265.692" y1="51.8342" x2="294.497"
                                    y2="84.5796" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint6_linear_28_2046" x1="404.206" y1="220.403" x2="441.148"
                                    y2="243.968" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint7_linear_28_2046" x1="380.292" y1="230.382" x2="429.922"
                                    y2="271.898" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint8_linear_28_2046" x1="381.138" y1="244.098" x2="410.717"
                                    y2="250.541" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint9_linear_28_2046" x1="293.98" y1="244.026" x2="370.041"
                                    y2="276.377" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint10_linear_28_2046" x1="427.321" y1="280.519" x2="459.683"
                                    y2="286.414" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint11_linear_28_2046" x1="455.761" y1="317.154" x2="495.428"
                                    y2="341.566" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint12_linear_28_2046" x1="106.054" y1="328.01" x2="118.604"
                                    y2="343.991" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint13_linear_28_2046" x1="61.9951" y1="206.703" x2="105.446"
                                    y2="213.772" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint14_linear_28_2046" x1="144.335" y1="287.393" x2="168.963"
                                    y2="291.28" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <linearGradient id="paint15_linear_28_2046" x1="151.586" y1="332.46" x2="184.511"
                                    y2="346.006" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#00A759" />
                                    <stop offset="0.484375" stop-color="#03C168" />
                                    <stop offset="1" stop-color="#00B05E" />
                                </linearGradient>
                                <clipPath id="clip0_28_2046">
                                    <rect width="435" height="377" fill="white" transform="translate(62 13)" />
                                </clipPath>
                            </defs>
                        </svg>

                    </div> --}}
                </div>
            </div>
            <!-- Left Shape -->
            <svg class="left--shape" width="172" height="555" viewBox="0 0 172 555" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <g opacity="0.19">
                    <g opacity="0.3">
                        <path
                            d="M-3.57898 275.511C-1.58262 277.217 1.16599 277.815 3.78866 277.68C6.40444 277.539 8.94008 276.734 11.4221 275.898C16.8846 274.066 21.8903 272.326 27.1018 269.913C29.2526 268.917 31.7543 267.417 33.7839 266.192C34.4355 265.802 35.0896 265.38 35.5401 264.77C35.9906 264.16 36.2009 263.317 35.8811 262.632C35.5264 261.864 34.6014 261.488 33.7508 261.522C32.9064 261.556 32.1066 261.908 31.33 262.245C24.7947 265.062 17.6009 266.972 10.5715 265.848C8.60603 265.536 6.68694 264.987 4.73158 264.655C2.77008 264.324 0.728518 264.208 -1.18297 264.757C-3.09445 265.306 -4.86621 266.599 -5.61699 268.443C-6.60305 270.871 -5.57385 273.817 -3.57749 275.523L-3.57898 275.511Z"
                            fill="url(#paint0_linear_28_1933)" />
                        <path
                            d="M70.0672 346.078C69.9645 344.038 68.8331 342.158 67.3526 340.746C65.8728 339.339 64.0609 338.335 62.2542 337.373C58.2935 335.261 54.6263 333.357 50.4709 331.699C48.7537 331.014 46.5652 330.405 44.7895 329.907C44.2217 329.751 43.63 329.604 43.0458 329.675C42.4616 329.745 41.8717 330.078 41.6512 330.629C41.4073 331.245 41.6939 331.966 42.1613 332.427C42.6349 332.888 43.2591 333.15 43.8649 333.414C48.9584 335.607 53.893 338.656 57.0164 343.241C57.8883 344.521 58.61 345.9 59.4703 347.188C60.3307 348.476 61.3634 349.693 62.6938 350.481C64.0241 351.269 65.7084 351.578 67.1505 351.017C69.0574 350.275 70.1691 348.113 70.0664 346.072L70.0672 346.078Z"
                            fill="url(#paint1_linear_28_1933)" />
                        <path
                            d="M105.356 278.613C103.388 280.136 101.564 269.21 102.005 263.447C102.444 257.678 109.676 258.566 108.514 266.675C107.353 274.784 105.944 278.155 105.35 278.613L105.356 278.613Z"
                            fill="url(#paint2_linear_28_1933)" />
                        <path
                            d="M112.345 339.287C106.088 345.702 96.5098 348.841 87.752 346.94C80.8593 345.45 74.9596 341.176 68.8601 337.625C59.8684 332.388 50.0555 328.567 39.887 326.349C30.4353 324.282 16.9569 327.88 8.64159 322.923C3.18386 319.675 -1.26726 314.584 -3.17129 308.523C-5.55895 300.936 -2.81309 291.375 1.16305 286.427C9.2289 276.387 28.7197 275.515 38.4734 267.106C46.3733 260.293 47.1947 250.553 54.4009 243.006C60.4164 236.708 69.9708 234.145 78.3947 236.33C86.8187 238.515 93.8479 245.274 96.6153 253.527C98.5657 259.351 98.4997 265.63 99.4072 271.705L99.4198 271.809C100.278 277.422 102.662 282.701 106.254 287.091C107.279 288.347 108.286 289.61 109.271 290.89C114.632 297.893 119.287 305.806 120.386 314.554C121.502 323.449 118.595 332.86 112.338 339.275L112.345 339.287Z"
                            fill="url(#paint3_linear_28_1933)" />
                    </g>
                    <path
                        d="M105.473 546.107C105.437 545.856 105.285 545.727 105.049 545.648C104.45 545.454 103.856 545.236 103.26 545.033C102.909 544.912 102.729 545.005 102.607 545.358C101.669 548.074 100.729 550.794 99.7848 553.508C99.7034 553.744 99.7167 553.938 99.8675 554.125L102.397 554.999L105.471 546.103L105.473 546.107Z"
                        fill="url(#paint4_linear_28_1933)" />
                    <path
                        d="M85.1687 534.349C85.3287 534.668 85.4955 534.986 85.6535 535.311C87.2883 538.672 88.9232 542.033 90.5551 545.393C90.6228 545.532 90.6869 545.654 90.8688 545.639C91.0933 544.198 92.1911 543.358 93.6192 543.546C93.8747 543.579 94.1266 543.67 94.3748 543.752C94.9517 543.945 95.5236 544.152 96.0986 544.341C96.1963 544.375 96.3319 544.374 96.4209 544.33C98.7065 543.228 100.986 542.114 103.268 541.004C103.303 540.988 103.333 540.966 103.381 540.94C103.344 540.86 103.313 540.782 103.277 540.708C102.667 539.458 102.053 538.207 101.45 536.956C101.064 536.153 101.276 535.297 101.959 534.828C102.302 534.593 102.659 534.526 103.046 534.718C103.557 534.972 104.083 535.051 104.631 534.854C105.333 534.601 105.768 534.095 105.895 533.366C106.038 532.55 105.767 531.855 105.113 531.346C103.81 530.329 102.184 531.209 102.002 532.526C101.955 532.867 101.745 533.11 101.428 533.255C100.682 533.599 99.806 533.341 99.3722 532.641C99.254 532.452 99.1639 532.247 99.0651 532.049C98.511 530.915 97.9598 529.782 97.4086 528.648C97.3747 528.579 97.3631 528.501 97.3362 528.401C96.5579 528.782 95.8365 529.138 95.1094 529.492C94.5486 529.765 93.986 530.033 93.4299 530.311C93.0451 530.503 92.8835 530.859 92.9812 531.247C93.0217 531.409 93.1005 531.507 93.2779 531.552C94.7097 531.924 95.3932 533.103 95.4772 534.127C95.6419 536.137 93.7856 537.644 91.8589 537.056C90.2907 536.575 89.4673 534.824 90.0532 533.221C90.1177 533.044 90.2291 532.88 90.0706 532.687C89.9026 532.484 89.7 532.362 89.4414 532.357C89.3164 532.355 89.1775 532.384 89.0654 532.439C87.7911 533.054 86.5187 533.673 85.2463 534.292C85.2269 534.301 85.2113 534.318 85.1677 534.352L85.1687 534.349Z"
                        fill="url(#paint5_linear_28_1933)" />
                    <path
                        d="M98.9421 553.368L101.692 545.409C100.768 544.993 99.8273 544.78 98.8331 545.116C98.0464 545.381 97.2479 545.485 96.4324 545.303C96.0352 545.214 95.6531 545.072 95.2659 544.945C94.6957 544.761 94.1355 544.538 93.5562 544.39C92.7601 544.189 91.8839 544.723 91.7404 545.445C91.7221 545.535 91.726 545.627 91.723 545.719C91.7173 545.894 91.7941 545.988 91.9695 546.049C92.8347 546.348 93.7029 546.638 94.5523 546.973C95.3481 547.287 95.9321 547.878 96.4102 548.571C96.5324 548.748 96.4875 548.98 96.3322 549.113C96.1681 549.253 95.9258 549.247 95.7689 549.086C95.6918 549.011 95.6332 548.92 95.5697 548.834C95.1233 548.226 94.5383 547.815 93.8283 547.569C92.6354 547.157 91.4454 546.746 90.2585 546.317C90.018 546.23 89.7995 546.071 89.5935 545.913C87.5038 544.316 85.4199 542.711 83.334 541.112C82.8333 540.727 82.2419 540.892 82.0876 541.46C82.0134 541.74 82.1137 541.971 82.2884 542.183C83.4266 543.554 84.5609 544.927 85.6962 546.298C86.466 547.227 87.2378 548.15 87.9989 549.085C88.3823 549.559 88.8519 549.885 89.4307 550.082C92.515 551.138 95.5944 552.208 98.6758 553.273L98.9431 553.365L98.9421 553.368Z"
                        fill="url(#paint6_linear_28_1933)" />
                    <path
                        d="M142.777 108.172C144.538 106.207 145.366 104.027 144.878 101.464C144.515 99.5318 143.516 97.9879 141.913 96.838C140.756 96.0087 139.467 95.5639 138.053 95.4884C136.621 95.4119 135.287 95.7411 134.036 96.4388C132.794 97.1316 131.917 98.185 131.105 99.3871C130.856 99.2001 130.626 99.0283 130.397 98.8564C128.48 97.4211 126.131 97.7545 124.625 99.6146C122.735 101.945 120.798 104.247 118.888 106.562C117.381 108.39 115.874 110.218 114.367 112.046C113.616 112.956 112.862 113.863 112.118 114.772C110.552 116.687 110.859 119.198 112.848 120.687C117.745 124.354 122.641 128.02 127.537 131.687C129.18 132.917 131.233 132.87 132.725 131.482C133.257 130.99 133.643 130.34 134.058 129.736C135.106 128.21 136.128 126.669 137.164 125.134C138.546 123.087 139.928 121.04 141.317 118.992C142.354 117.457 143.383 115.923 144.44 114.403C145.631 112.695 145.518 110.656 144.075 109.15C143.724 108.78 143.252 108.52 142.776 108.165L142.777 108.172ZM133.079 100.847C134.282 98.8968 135.893 97.6853 138.26 97.9734C140.298 98.2221 141.692 99.3909 142.324 101.342C142.994 103.41 142.25 105.133 140.851 106.666L133.075 100.843L133.079 100.847ZM139.395 111.984C138.997 112.507 138.208 112.611 137.694 112.207C137.172 111.797 137.073 111.022 137.475 110.502C137.884 109.982 138.665 109.878 139.18 110.282C139.702 110.692 139.799 111.453 139.395 111.984ZM128.405 103.723C128.802 103.193 129.575 103.083 130.103 103.478C130.63 103.873 130.733 104.652 130.336 105.181C129.948 105.699 129.151 105.816 128.637 105.419C128.109 105.017 128.004 104.25 128.405 103.723Z"
                        fill="url(#paint7_linear_28_1933)" />
                    <path
                        d="M75.5085 273.903C72.2498 273.903 68.991 273.903 65.7377 273.903C64.9135 273.903 64.122 274.073 63.4124 274.526C62.6154 275.039 62.0696 275.743 61.7748 276.638C60.8087 279.537 59.8097 282.419 58.8818 285.328C57.6645 289.165 59.908 292.894 63.86 293.592C65.6777 293.914 67.3589 293.461 68.8545 292.359C68.9856 292.26 69.1111 292.151 69.2421 292.048C69.8971 291.524 70.5139 291.513 71.1526 292.037C72.5336 293.172 74.122 293.712 75.9015 293.614C77.3317 293.538 78.609 293.03 79.7334 292.135C80.5522 291.485 81.0599 291.485 81.8732 292.135C84.2476 294.013 87.5774 294.155 89.8809 292.479C92.1407 290.83 93.0195 287.976 92.097 285.17C91.1745 282.359 90.2357 279.553 89.2859 276.753C88.6636 274.913 87.2335 273.903 85.2738 273.898C82.0151 273.898 78.7563 273.898 75.5031 273.898L75.5085 273.903Z"
                        fill="url(#paint8_linear_28_1933)" />
                    <path
                        d="M90.05 295.666C89.2422 295.879 88.5053 296.12 87.7575 296.261C85.4212 296.709 83.2378 296.251 81.2127 295.039C80.907 294.853 80.6941 294.859 80.3993 295.039C78.9201 295.945 77.2934 296.392 75.5685 296.403C73.7727 296.414 72.0805 295.945 70.5412 295C70.3174 294.864 70.1537 294.837 69.908 294.984C67.1897 296.66 64.3349 296.895 61.3599 295.748C61.2562 295.71 61.158 295.672 60.9997 295.612C60.9888 295.754 60.9669 295.868 60.9669 295.983C60.9669 299.597 60.956 303.216 60.9669 306.829C60.9724 308.822 62.1896 310.383 64.051 310.814C64.384 310.89 64.7333 310.929 65.0718 310.934C66.1908 310.95 67.3098 310.929 68.4233 310.945C68.7563 310.945 68.8491 310.847 68.8436 310.519C68.8272 308.876 68.8327 307.233 68.8436 305.59C68.8491 303.445 70.6231 301.665 72.7683 301.66C74.5915 301.66 76.4092 301.66 78.2323 301.66C80.3775 301.665 82.157 303.445 82.1625 305.585C82.1625 307.228 82.1734 308.871 82.1625 310.514C82.1625 310.83 82.2389 310.956 82.5773 310.945C83.9256 310.907 85.2793 310.945 86.6275 310.852C88.2979 310.743 89.8208 309.193 89.9736 307.533C90.0173 307.042 90.0446 306.545 90.0446 306.049C90.0501 302.735 90.0446 299.422 90.0446 296.114V295.666H90.05Z"
                        fill="url(#paint9_linear_28_1933)" />
                    <path
                        d="M79.477 310.934C79.477 309.138 79.4879 307.37 79.477 305.601C79.4715 304.919 78.9093 304.362 78.227 304.357C76.4202 304.34 74.608 304.34 72.8012 304.357C72.1243 304.357 71.5566 304.924 71.5512 305.601C71.5348 307.37 71.5512 309.133 71.5512 310.934H79.4879H79.477Z"
                        fill="url(#paint10_linear_28_1933)" />
                    <path
                        d="M114.554 207.283H78.238C78.4885 208.166 78.7331 209.031 78.9777 209.89C80.5346 215.295 82.0975 220.699 83.6425 226.104C83.7558 226.497 83.899 226.647 84.3344 226.641C92.3875 226.623 100.441 226.629 108.5 226.641C108.875 226.641 109.042 226.551 109.15 226.169C110.909 220.013 112.687 213.857 114.459 207.701C114.495 207.576 114.518 207.439 114.554 207.283V207.283ZM83.5649 211.298C83.6723 211.149 83.7856 210.851 83.9825 210.767C84.1853 210.678 84.5074 210.743 84.7281 210.851C84.8653 210.916 84.9488 211.161 84.9966 211.346C85.6706 214.012 86.3328 216.685 87.0009 219.351C87.2514 220.359 87.5079 221.361 87.7406 222.375C87.836 222.805 87.6272 223.121 87.2574 223.205C86.8637 223.294 86.5654 223.121 86.4223 222.709C86.3924 222.626 86.3745 222.536 86.3566 222.447C85.6706 219.721 84.9846 216.995 84.3046 214.269C84.066 213.32 83.8393 212.372 83.5768 211.304L83.5649 211.298ZM108.398 210.678C109.084 210.69 109.311 211.107 109.144 211.775C108.422 214.662 107.706 217.556 106.978 220.443C106.787 221.2 106.603 221.964 106.394 222.715C106.274 223.133 105.946 223.306 105.565 223.211C105.201 223.121 105.016 222.829 105.07 222.417C105.087 222.298 105.117 222.179 105.141 222.065C105.547 220.431 105.952 218.796 106.364 217.162C106.847 215.223 107.33 213.278 107.814 211.34C107.909 210.952 108.1 210.678 108.398 210.678V210.678ZM98.5734 222.56C98.7404 220.478 98.8895 218.605 99.0446 216.732C99.1878 214.961 99.3369 213.195 99.492 211.423C99.5338 210.916 99.8261 210.648 100.273 210.69C100.691 210.725 100.912 211.024 100.876 211.531C100.846 211.948 100.804 212.372 100.769 212.789C100.5 216.017 100.226 219.238 99.9514 222.465C99.9096 222.99 99.6352 223.264 99.2057 223.234C98.7822 223.205 98.5555 222.894 98.5674 222.566L98.5734 222.56ZM91.9759 212.014C91.9341 211.083 92.0415 210.821 92.3875 210.707C92.9005 210.54 93.2822 210.886 93.3359 211.531C93.503 213.589 93.6819 215.641 93.8489 217.699C93.9802 219.274 94.1174 220.848 94.2307 222.429C94.2665 222.918 93.9981 223.228 93.5865 223.246C93.1749 223.264 92.9005 222.984 92.8587 222.501C92.7573 221.343 92.6678 220.186 92.5664 219.035C92.3576 216.601 92.1548 214.173 91.9699 212.02L91.9759 212.014Z"
                        fill="url(#paint11_linear_28_1933)" />
                    <path
                        d="M96.3903 201.742C89.6197 201.742 82.8492 201.742 76.0787 201.742C74.5576 201.742 73.5316 203.156 74.0625 204.528C74.3905 205.369 75.0408 205.798 75.9296 205.882C76.0191 205.888 76.1085 205.882 76.198 205.882C89.6615 205.882 103.131 205.882 116.594 205.882C117.155 205.882 117.668 205.762 118.11 205.404C118.79 204.85 119.046 203.931 118.76 203.12C118.462 202.273 117.704 201.736 116.791 201.736C111.303 201.736 105.815 201.736 100.327 201.736C99.0149 201.736 97.7026 201.736 96.3903 201.736V201.742Z"
                        fill="url(#paint12_linear_28_1933)" />
                    <path
                        d="M104.032 200.358H104.539C106.71 200.358 108.881 200.352 111.053 200.364C111.363 200.364 111.536 200.268 111.697 200C112.967 197.864 114.041 195.645 114.447 193.176C114.59 192.311 114.614 191.398 114.495 190.533C114.292 189.03 113.301 188.451 111.816 188.839C110.396 189.209 109.233 190.044 108.136 190.974C106.609 192.269 105.338 193.796 104.205 195.442C104.121 195.562 104.038 195.711 104.038 195.848C104.026 197.321 104.032 198.801 104.032 200.352V200.358ZM109.985 198.592C109.776 198.538 109.663 198.532 109.579 198.479C108.583 197.834 107.581 197.196 106.609 196.522C106.298 196.307 106.274 195.955 106.507 195.639C106.728 195.335 107.05 195.216 107.378 195.419C108.368 196.039 109.358 196.671 110.307 197.357C110.474 197.477 110.552 197.882 110.492 198.115C110.438 198.318 110.14 198.461 109.991 198.598L109.985 198.592ZM110.695 196.158C110.516 196.128 110.444 196.134 110.402 196.105C109.699 195.651 108.977 195.216 108.303 194.715C108.046 194.524 108.07 194.166 108.267 193.891C108.458 193.623 108.756 193.474 109.054 193.653C109.734 194.059 110.408 194.488 111.041 194.971C111.196 195.09 111.255 195.478 111.184 195.687C111.112 195.896 110.832 196.033 110.701 196.158H110.695Z"
                        fill="url(#paint13_linear_28_1933)" />
                    <path d="M82.7296 192.072V200.328H91.9935V192.072H82.7296Z" fill="url(#paint14_linear_28_1933)" />
                    <path
                        d="M93.4196 200.334H102.624C102.636 200.179 102.648 200.048 102.648 199.916C102.648 197.638 102.648 195.359 102.648 193.086C102.648 192.317 102.361 192.03 101.58 192.03C99.2119 192.03 96.8437 192.03 94.4755 192.03C93.694 192.03 93.4196 192.311 93.4196 193.098C93.4196 195.359 93.4196 197.626 93.4196 199.886V200.34V200.334ZM100.811 196.331C100.811 197.846 99.5578 199.099 98.0486 199.105C96.5275 199.117 95.239 197.828 95.251 196.313C95.2569 194.774 96.5216 193.533 98.0665 193.551C99.5936 193.569 100.822 194.81 100.817 196.331H100.811Z"
                        fill="url(#paint15_linear_28_1933)" />
                    <path
                        d="M78.0475 200.328H81.3045V199.863C81.3045 197.226 81.3104 194.584 81.2925 191.947C81.2925 191.696 81.2031 191.416 81.0718 191.201C80.6364 190.503 80.1591 189.829 79.664 189.102C79.1093 189.925 78.5843 190.688 78.0713 191.464C78.0117 191.553 78.0176 191.696 78.0176 191.816C78.0176 194.548 78.0176 197.274 78.0176 200.006C78.0176 200.107 78.0415 200.209 78.0534 200.334L78.0475 200.328Z"
                        fill="url(#paint16_linear_28_1933)" />
                    <path
                        d="M80.9939 188.588C81.4413 189.245 81.8588 189.877 82.2943 190.503C82.342 190.575 82.4732 190.622 82.5627 190.622C85.4678 190.628 88.3788 190.622 91.3912 190.622C90.914 189.913 90.4845 189.268 90.0431 188.636C89.9894 188.564 89.8283 188.535 89.721 188.535C86.8696 188.535 84.0242 188.535 81.1728 188.535C81.1311 188.535 81.0953 188.559 80.9939 188.588V188.588Z"
                        fill="url(#paint17_linear_28_1933)" />
                    <path d="M82.4974 185.379V187.133H87.5082V185.379H82.4974Z" fill="url(#paint18_linear_28_1933)" />
                    <path d="M99.9216 190.599V189.167H96.1516V190.599H99.9216Z" fill="url(#paint19_linear_28_1933)" />
                    <path
                        d="M99.4083 196.331C99.4142 195.556 98.8237 194.953 98.0542 194.947C97.2787 194.947 96.6702 195.526 96.6464 196.289C96.6285 197.059 97.2608 197.715 98.0303 197.721C98.77 197.721 99.4023 197.089 99.4083 196.331V196.331Z"
                        fill="url(#paint20_linear_28_1933)" />
                    <path
                        d="M36.3816 121.666C36.6155 121.14 37.0165 120.952 37.5929 120.96C39.4392 120.985 41.2896 120.969 43.14 120.969C44.7273 120.969 45.9178 122.159 46.0264 123.738C46.1099 124.966 46.2895 126.19 46.4232 127.418C46.465 127.794 46.5067 128.17 46.5527 128.571H46.9787C53.875 128.571 60.7755 128.579 67.6718 128.558C68.5156 128.558 68.9291 129.151 68.7996 129.899C68.2942 132.744 67.8431 135.597 67.3669 138.441C67.2959 138.867 67.2374 139.297 67.133 139.715C66.8072 141.023 65.7086 141.875 64.3636 141.875C58.6285 141.875 52.8934 141.875 47.1542 141.875C46.6947 141.875 46.3188 142.004 46.1099 142.439C45.8259 143.032 46.2352 143.708 46.9119 143.775C47.0289 143.788 47.1458 143.779 47.2586 143.779C52.2251 143.779 57.1874 143.779 62.1539 143.779C63.7872 143.779 65.0361 145.049 65.0236 146.682C65.0152 148.094 63.8999 149.327 62.4923 149.473C61.047 149.627 59.6602 148.658 59.4013 147.246C59.3094 146.753 59.3887 146.227 59.3887 145.697H53.4782C53.7957 146.824 53.5952 147.831 52.7598 148.667C52.1499 149.272 51.3981 149.523 50.5418 149.477C49.2051 149.402 47.4215 148.015 48.0481 145.676C47.693 145.676 47.3505 145.676 47.0038 145.676C45.6504 145.672 44.4976 144.782 44.1927 143.512C43.8836 142.226 44.46 140.935 45.6504 140.308C45.8551 140.2 45.9178 140.087 45.8927 139.87C45.7298 138.454 45.5711 137.042 45.4124 135.626C45.2536 134.21 45.0991 132.794 44.9403 131.382C44.7816 129.945 44.6187 128.508 44.46 127.075C44.343 126.019 44.2177 124.958 44.1175 123.897C44.0548 123.233 43.6831 122.861 43.0106 122.861C41.2061 122.861 39.3974 122.844 37.5929 122.869C37.0165 122.877 36.6155 122.69 36.3816 122.163V121.658V121.666ZM49.8191 135.237C49.8191 135.826 49.8191 136.419 49.8191 137.008C49.8191 137.639 50.2243 138.086 50.7757 138.082C51.3187 138.078 51.7197 137.635 51.7197 137.029C51.7197 135.826 51.7239 134.623 51.7197 133.42C51.7197 132.815 51.3062 132.376 50.7631 132.38C50.2201 132.384 49.8233 132.827 49.8191 133.433C49.8191 134.034 49.8191 134.636 49.8191 135.237ZM57.4255 135.246C57.4255 134.644 57.4255 134.043 57.4255 133.441C57.4255 132.815 57.0078 132.368 56.4565 132.38C55.9134 132.393 55.525 132.831 55.5208 133.445C55.5208 134.636 55.5208 135.83 55.5208 137.021C55.5208 137.635 55.9134 138.074 56.4565 138.086C57.0078 138.099 57.4213 137.648 57.4213 137.021C57.4213 136.432 57.4213 135.839 57.4213 135.25L57.4255 135.246ZM61.2266 135.2C61.2266 135.81 61.2266 136.424 61.2266 137.033C61.2308 137.639 61.636 138.082 62.179 138.082C62.722 138.082 63.1272 137.639 63.1272 137.033C63.1272 135.83 63.1314 134.628 63.1272 133.425C63.1272 132.819 62.7178 132.376 62.1748 132.376C61.6318 132.376 61.2308 132.819 61.2266 133.425C61.2266 134.013 61.2266 134.607 61.2266 135.196V135.2Z"
                        fill="url(#paint21_linear_28_1933)" />
                    <path
                        d="M57.4254 126.645C57.4254 125.029 57.4171 123.433 57.4296 121.842C57.4296 121.336 57.864 120.969 58.407 120.969C60.341 120.969 62.2708 120.969 64.2048 120.969C64.8063 120.969 65.4078 120.96 66.0093 120.969C66.5022 120.977 66.9199 121.361 66.9199 121.842C66.9324 123.433 66.924 125.029 66.924 126.645H57.4213H57.4254Z"
                        fill="url(#paint22_linear_28_1933)" />
                    <path
                        d="M49.8191 126.645C49.8191 125.66 49.8108 124.699 49.8191 123.742C49.8233 123.299 50.2034 122.886 50.642 122.882C52.2543 122.865 53.8708 122.873 55.4999 122.873V126.645H49.8149H49.8191Z"
                        fill="url(#paint23_linear_28_1933)" />
                    <path
                        d="M165.662 260.066C164.378 254.655 159.667 252.347 155.577 253.085C154.971 253.196 154.369 253.371 153.783 253.571C152.394 254.047 151.019 254.561 149.637 255.058C148.766 255.372 148.64 255.862 149.265 256.527C149.849 257.159 150.449 257.774 151.014 258.419C152.368 259.954 152.109 262.314 150.267 263.179C148.379 264.066 146.367 264.821 144.33 265.228C141.832 265.737 139.619 263.876 139.035 261.268C138.581 259.231 138.05 257.215 137.551 255.187C137.41 254.615 137.27 254.043 137.122 253.419C136.655 253.588 136.22 253.715 135.82 253.906C135.719 253.955 135.667 254.205 135.671 254.364C135.787 256.992 135.92 259.619 136.049 262.249C136.086 263.078 136.129 263.905 136.167 264.769C136.3 264.775 136.42 264.779 136.54 264.783C138.529 264.868 140.183 265.589 141.318 267.292C141.772 267.977 141.953 268.677 141.356 269.39C141.306 269.45 141.313 269.602 141.349 269.684C141.429 269.857 141.546 270.016 141.673 270.22L142.066 270.078C146.168 268.601 150.275 267.121 154.376 265.644C154.618 265.557 154.757 265.465 154.797 265.166C154.923 264.296 155.446 263.722 156.276 263.423C159.248 262.353 162.225 261.28 165.198 260.21L165.66 260.043L165.662 260.066ZM158.572 259.553C159.449 259.237 160.326 258.921 161.197 258.607C161.696 258.427 162.103 258.583 162.247 259C162.381 259.391 162.177 259.779 161.699 259.951C159.963 260.582 158.225 261.208 156.484 261.829C156.007 262.001 155.609 261.836 155.465 261.437C155.314 261.017 155.515 260.654 156.025 260.47C156.875 260.164 157.721 259.859 158.572 259.553ZM157.441 258.406C156.779 258.644 156.121 258.893 155.45 259.123C154.995 259.275 154.616 259.097 154.482 258.706C154.34 258.312 154.529 257.948 154.98 257.785C156.293 257.312 157.6 256.823 158.917 256.379C159.133 256.301 159.467 256.341 159.659 256.461C160.14 256.775 160.004 257.453 159.42 257.693C158.768 257.957 158.099 258.174 157.437 258.413L157.441 258.406Z"
                        fill="url(#paint24_linear_28_1933)" />
                    <path
                        d="M152.961 252.342C153.11 252.294 153.257 252.259 153.399 252.208C156.996 250.912 160.594 249.617 164.191 248.321C165.01 248.026 165.126 247.771 164.831 246.951C163.864 244.268 162.9 241.589 161.933 238.906L161.77 238.454L159.712 239.196C159.793 239.422 159.883 239.638 159.952 239.863C160.069 240.236 159.908 240.597 159.576 240.746C159.254 240.891 158.858 240.761 158.675 240.418C158.553 240.195 158.473 239.957 158.359 239.689L152.934 241.643C152.991 241.801 153.057 241.984 153.121 242.163C153.285 242.65 153.12 243.083 152.717 243.216C152.325 243.346 151.944 243.127 151.77 242.662C151.709 242.493 151.647 242.32 151.577 242.126L149.55 242.856L152.966 252.34L152.961 252.342Z"
                        fill="url(#paint25_linear_28_1933)" />
                    <path
                        d="M132.441 274.453C133.401 276.623 135.665 277.705 137.842 277.011C140.554 276.14 141.71 272.894 140.164 270.496C139.977 270.208 139.813 270.113 139.452 270.248C137.165 271.096 134.87 271.923 132.567 272.728C132.226 272.851 132.133 273.021 132.208 273.344C132.293 273.711 132.361 274.084 132.443 274.458L132.441 274.453Z"
                        fill="url(#paint26_linear_28_1933)" />
                    <path
                        d="M164.094 262.168L163.679 262.317C161.41 263.134 159.141 263.951 156.873 264.769C156.211 265.007 156.04 265.371 156.314 266.002C157.294 268.26 159.846 269.251 162.099 268.291C164.111 267.436 165.193 264.922 164.393 262.801C164.317 262.591 164.202 262.402 164.088 262.17L164.094 262.168Z"
                        fill="url(#paint27_linear_28_1933)" />
                    <path
                        d="M130.776 271.855L140.286 268.429C140.008 267.723 139.504 267.246 138.89 266.891C137.721 266.215 136.482 266.02 135.191 266.456C134.355 266.739 133.477 267.002 132.736 267.464C131.291 268.377 130.536 269.722 130.693 271.493C130.702 271.602 130.74 271.707 130.776 271.855V271.855Z"
                        fill="url(#paint28_linear_28_1933)" />
                    <path
                        d="M161.259 237.037C161.093 236.574 160.946 236.135 160.779 235.703C160.632 235.328 160.28 235.159 159.892 235.251C159.783 235.278 159.682 235.326 159.572 235.366C156.137 236.603 152.698 237.842 149.263 239.079C148.491 239.357 148.359 239.648 148.635 240.433C148.754 240.764 148.874 241.094 149.006 241.462L161.263 237.047L161.259 237.037Z"
                        fill="url(#paint29_linear_28_1933)" />
                    <path
                        d="M132.331 250.559L133.299 253.248C133.424 253.215 133.534 253.193 133.634 253.157C134.852 252.718 136.078 252.283 137.294 251.839C138.14 251.534 138.543 250.742 138.268 249.963C137.99 249.174 137.157 248.821 136.295 249.131C134.983 249.604 133.675 250.075 132.331 250.559Z"
                        fill="url(#paint30_linear_28_1933)" />
                    <path
                        d="M151.585 252.855C151.398 252.336 151.253 251.883 151.074 251.438C150.915 251.062 150.599 250.909 150.214 251.041C149.373 251.326 148.538 251.627 147.711 251.949C147.217 252.144 146.98 252.705 147.119 253.206C147.268 253.734 147.776 254.091 148.315 253.974C148.767 253.876 149.202 253.702 149.64 253.55C150.277 253.326 150.911 253.092 151.588 252.848L151.585 252.855Z"
                        fill="url(#paint31_linear_28_1933)" />
                    <path
                        d="M52.9659 496.37C55.5319 496.616 57.7677 495.621 59.9255 494.428C62.8292 492.821 65.3705 490.768 67.4792 488.185C71.8026 482.886 70.2557 475.121 64.6831 471.637C59.4696 468.374 52.4779 469.926 49.1996 475.125C49.1479 475.209 49.0709 475.283 49.0084 475.362L47.8278 478.197C47.7437 478.722 47.6387 479.248 47.5778 479.779C47.1547 483.376 47.5777 486.895 48.653 490.336C49.3224 492.474 50.1664 494.538 52.0231 495.981L52.968 496.375L52.9659 496.37ZM62.6976 482.842C61.7819 485.041 59.2416 486.099 57.0434 485.192C54.8539 484.285 53.7907 481.726 54.6963 479.531C55.6003 477.34 58.1616 476.282 60.3562 477.187C62.5508 478.093 63.6068 480.649 62.6925 482.844L62.6976 482.842Z"
                        fill="url(#paint32_linear_28_1933)" />
                    <path
                        d="M86.3243 466.594C86.248 466.777 86.1882 466.921 86.1298 467.061C85.0704 469.605 84.0111 472.149 82.9481 474.691C82.6548 475.395 82.1899 475.711 81.5582 475.558C81.2795 475.488 80.9962 475.277 80.7977 475.056C79.9276 474.078 79.0787 473.079 78.2364 472.075C78.0843 471.894 77.9406 471.834 77.7046 471.853C76.4123 471.96 75.1208 472.055 73.8272 472.144C72.6638 472.225 72.0895 471.437 72.5363 470.354C73.584 467.819 74.6446 465.292 75.6995 462.759C75.7638 462.605 75.8282 462.45 75.903 462.271C75.7658 462.205 75.6661 462.151 75.5584 462.106C73.2446 461.142 70.9309 460.179 68.6172 459.215C67.9058 458.919 67.2655 459.171 66.9722 459.875C65.8215 462.638 64.6724 465.397 63.5217 468.16C63.4963 468.221 63.4795 468.281 63.4427 468.38C67.9983 470.277 70.9962 473.566 72.016 478.426C73.038 483.291 71.5421 487.47 68.0756 491.056L68.5175 491.24C73.0479 493.127 77.5784 495.014 82.1089 496.901C82.9891 497.267 83.5642 497.03 83.9293 496.154C87.3693 487.894 90.8108 479.631 94.2508 471.371C94.6069 470.516 94.3664 469.939 93.5078 469.582C91.2551 468.643 89.0024 467.705 86.7498 466.767C86.6205 466.713 86.4911 466.659 86.3258 466.591L86.3243 466.594Z"
                        fill="url(#paint33_linear_28_1933)" />
                    <path
                        d="M75.3967 469.661C75.55 469.658 75.6757 469.66 75.7972 469.651C76.6322 469.59 77.4677 469.537 78.3021 469.468C78.7999 469.426 79.1931 469.586 79.5128 469.972C80.0509 470.613 80.5971 471.245 81.1433 471.878C81.225 471.975 81.3148 472.063 81.4295 472.182L84.1259 465.708L78.0864 463.193L75.3931 469.66L75.3967 469.661Z"
                        fill="url(#paint34_linear_28_1933)" />
                    <path
                        d="M60.5257 481.934C60.947 480.912 60.4771 479.793 59.4481 479.368C58.4349 478.947 57.2956 479.425 56.8757 480.443C56.4588 481.454 56.935 482.588 57.9605 483.011C58.9772 483.435 60.1064 482.961 60.5257 481.934V481.934Z"
                        fill="url(#paint35_linear_28_1933)" />
                    <path
                        d="M50.1804 403.464C50.4191 401.897 49.9415 400.572 48.8091 399.485C47.3058 398.043 44.8589 397.913 43.1685 399.171C43.0249 399.278 42.9203 399.229 42.8005 399.164C42.067 398.755 41.3349 398.343 40.6006 397.929C40.0402 397.615 39.4876 397.29 38.9215 396.989C38.4707 396.75 37.9866 396.75 37.4952 396.839C34.1302 397.449 30.7637 398.051 27.3979 398.657C27.2207 398.69 27.0406 398.718 26.8618 398.753C26.4251 398.836 26.2934 399.028 26.3759 399.461C26.8596 401.977 27.3427 404.489 27.828 407.002C27.9293 407.526 28.029 408.051 28.134 408.573C28.2119 408.949 28.4205 409.096 28.7963 409.028C32.3839 408.383 35.9731 407.735 39.5607 407.09C40.143 406.986 40.5933 406.697 40.9477 406.224C41.2443 405.827 41.5729 405.451 41.8877 405.065C41.9268 405.018 41.9772 404.979 42.0387 404.924C42.4639 405.582 42.9868 406.112 43.6966 406.522C43.754 406.199 43.82 405.921 43.8453 405.64C43.851 405.563 43.7516 405.468 43.6881 405.394C43.3871 405.04 43.0791 404.691 42.7774 404.332C42.6723 404.206 42.6853 404.094 42.8071 403.956C43.2113 403.494 43.5981 403.014 43.9857 402.538C44.5436 401.852 44.5583 400.764 44.0258 400.032C43.9798 399.967 43.9322 399.904 43.8847 399.841C44.699 399.11 46.309 399.026 47.5077 399.643C48.6995 400.257 49.4767 401.704 49.3224 403.049C49.2358 403.034 49.1499 403.022 49.0658 402.998C47.1299 402.519 45.151 403.351 44.1823 405.095C43.8492 405.693 43.8304 405.549 44.4371 405.854C44.927 406.1 45.4676 406.179 46.018 406.16C46.2793 406.151 46.4649 406.292 46.5193 406.531C46.5505 406.667 46.5056 406.864 46.4166 406.965C46.3308 407.06 46.1474 407.102 46.0036 407.111C45.2571 407.146 44.5717 406.975 43.739 406.568C43.7196 406.635 43.6919 406.7 43.6841 406.765C43.5304 408.242 43.8543 409.567 44.9299 410.648C45.0694 410.787 45.0561 410.919 45 411.089C44.0467 413.966 43.1042 416.847 42.1486 419.722C42.0621 419.985 42.0715 420.196 42.1965 420.44C42.4331 420.898 42.6403 421.37 42.8583 421.835C43.0055 422.144 43.0797 422.168 43.3829 422.02C43.8508 421.794 44.3217 421.573 44.7919 421.348C44.8326 421.289 44.8734 421.229 44.9142 421.17C44.7978 420.909 44.6939 420.639 44.5591 420.385C44.4392 420.158 44.4888 420.018 44.7101 419.901C44.926 419.787 45.1276 419.65 45.3435 419.536C45.5601 419.426 45.5898 419.275 45.4974 419.067C45.3892 418.828 45.2996 418.582 45.193 418.341C45.111 418.157 45.1572 418.031 45.3306 417.935C45.5668 417.801 45.7969 417.657 46.0338 417.527C46.211 417.43 46.2505 417.299 46.1776 417.122C46.0787 416.879 45.9945 416.63 45.877 416.395C45.7529 416.145 45.8318 415.991 46.0571 415.863C46.3095 415.721 46.5453 415.553 46.7985 415.414C47.0013 415.305 47.1178 415.15 47.1946 414.93C47.5391 413.944 47.9066 412.963 48.2511 411.977C48.3174 411.787 48.4176 411.705 48.6101 411.679C50.4544 411.43 51.6755 410.39 52.2293 408.643C52.7807 406.905 52.3376 405.358 51.0504 404.071C50.7987 403.821 50.4667 403.653 50.1714 403.447C50.0775 403.746 49.9927 404.05 49.8865 404.347C49.829 404.509 49.8174 404.629 49.9266 404.788C50.3643 405.428 50.2753 406.213 49.7292 406.769C49.2321 407.278 48.3948 407.382 47.7798 407.01C47.0756 406.587 46.7837 405.842 47.0334 405.107C47.2678 404.418 47.9754 403.969 48.7127 404.045C48.8079 404.054 48.9045 404.069 49.0188 404.084L49.2788 403.211L50.1759 403.461L50.1804 403.464ZM32.181 405.041C32.103 404.901 32.0159 404.807 31.992 404.7C31.7833 403.663 31.5838 402.622 31.3927 401.584C31.3497 401.353 31.452 401.175 31.6844 401.096C31.9074 401.02 32.1002 401.082 32.232 401.277C32.2847 401.356 32.3041 401.46 32.322 401.557C32.5051 402.499 32.686 403.439 32.8653 404.382C32.8804 404.463 32.9198 404.557 32.8897 404.621C32.8279 404.76 32.758 404.93 32.6395 405C32.521 405.07 32.3387 405.032 32.181 405.041V405.041ZM35.7379 400.427C35.8122 400.613 35.8888 400.746 35.9191 400.888C36.109 401.845 36.2896 402.805 36.4718 403.764C36.5362 404.11 36.4124 404.344 36.1397 404.399C35.8593 404.455 35.6466 404.276 35.5768 403.922C35.4819 403.444 35.3908 402.964 35.2997 402.485C35.205 401.987 35.1088 401.491 35.0164 400.994C34.9763 400.778 35.0205 400.577 35.2292 400.488C35.3714 400.428 35.5463 400.447 35.7386 400.431L35.7379 400.427Z"
                        fill="url(#paint36_linear_28_1933)" />
                    <path
                        d="M49.0136 405.085C48.703 404.872 48.2486 404.956 48.0277 405.268C47.8209 405.56 47.9084 406.02 48.2113 406.234C48.518 406.448 48.9909 406.366 49.2071 406.061C49.4311 405.745 49.347 405.314 49.0159 405.087L49.0136 405.085Z"
                        fill="url(#paint37_linear_28_1933)" />
                    <g opacity="0.3">
                        <path
                            d="M56.6429 46.7991C54.6202 46.7526 52.688 47.7339 51.1881 49.0919C49.6951 50.4497 48.5733 52.1651 47.4986 53.8728C45.1296 57.6266 42.9882 61.1027 41.0521 65.0813C40.253 66.7231 39.4898 68.8368 38.8744 70.5562C38.6756 71.1067 38.4906 71.6772 38.5186 72.2606C38.5465 72.844 38.8314 73.4496 39.356 73.703C39.942 73.9891 40.6769 73.7627 41.1682 73.3282C41.6562 72.8971 41.962 72.2973 42.2616 71.7179C44.7918 66.8541 48.1565 62.2108 52.9005 59.4589C54.2258 58.6881 55.6386 58.0811 56.9676 57.3271C58.3 56.5697 59.5751 55.6446 60.4491 54.3862C61.323 53.1277 61.751 51.4928 61.3012 50.0263C60.7077 48.0967 58.6586 46.839 56.636 46.7925L56.6429 46.7991Z"
                            fill="url(#paint38_linear_28_1933)" />
                        <path
                            d="M-21.6872 40.5311C-20.6322 41.6994 -19.0417 42.2704 -17.4699 42.3928C-15.9015 42.5119 -14.3307 42.2294 -12.7838 41.9236C-9.39091 41.2558 -6.27438 40.6068 -2.98627 39.5731C-1.6274 39.146 -0.0239864 38.4442 1.2782 37.8764C1.69325 37.6931 2.1181 37.4928 2.43255 37.1662C2.747 36.8397 2.93691 36.3535 2.80037 35.9173C2.64599 35.4307 2.12406 35.1401 1.62024 35.0922C1.11311 35.0477 0.613003 35.1954 0.122827 35.3329C-3.98624 36.5035 -8.417 37.0861 -12.514 35.8701C-13.6579 35.5304 -14.7605 35.0583 -15.9012 34.7084C-17.0419 34.3585 -18.2511 34.1348 -19.4291 34.3121C-20.6071 34.4895 -21.7628 35.1254 -22.3507 36.1625C-23.1279 37.5339 -22.7387 39.3661 -21.6837 40.5344L-21.6872 40.5311Z"
                            fill="url(#paint39_linear_28_1933)" />
                        <path
                            d="M-9.90326 97.9929C-9.46957 96.125 -3.061 101.76 -0.517554 105.415C2.02933 109.073 -2.72021 112.065 -5.97535 106.658C-9.23048 101.251 -10.031 98.5522 -9.89995 97.9895L-9.90326 97.9929Z"
                            fill="url(#paint40_linear_28_1933)" />
                        <path
                            d="M-43.6208 65.1729C-43.0088 58.2963 -38.8194 51.7576 -32.665 48.6281C-27.8245 46.1613 -22.2209 45.8402 -16.8502 44.9903C-8.93202 43.7382 -1.21299 41.241 5.93778 37.6136C12.5872 34.2454 18.882 25.534 26.2598 24.444C31.0998 23.7255 36.2366 24.5979 40.3245 27.2889C45.4445 30.656 48.4608 37.7009 48.4962 42.591C48.5698 52.5128 37.3584 62.5245 35.6301 72.2945C34.2311 80.2086 38.4838 86.4237 37.8563 94.4381C37.3319 101.128 32.8758 107.31 26.7826 110.108C20.6894 112.905 13.2016 112.293 7.53077 108.713C3.53037 106.186 0.511994 102.405 -2.98785 99.2201L-3.0463 99.1638C-6.29159 96.2308 -10.2852 94.24 -14.568 93.3685C-15.7913 93.118 -17.008 92.8539 -18.2183 92.5695C-24.8299 90.999 -31.4617 88.5413 -36.3772 83.8541C-41.3754 79.0874 -44.2226 72.0528 -43.6106 65.1761L-43.6208 65.1729Z"
                            fill="url(#paint41_linear_28_1933)" />
                    </g>
                </g>
                <defs>
                    <linearGradient id="paint0_linear_28_1933" x1="16.1312" y1="276.227" x2="14.5049" y2="262.746"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint1_linear_28_1933" x1="57.4723" y1="352.314" x2="54.5734" y2="328.284"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint2_linear_28_1933" x1="106.79" y1="278.542" x2="104.528" y2="259.791"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint3_linear_28_1933" x1="63.2413" y1="351.261" x2="49.592" y2="238.119"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint4_linear_28_1933" x1="104.171" y1="545.345" x2="101.001" y2="554.517"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint5_linear_28_1933" x1="97.4541" y1="528.442" x2="91.4353" y2="545.862"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint6_linear_28_1933" x1="92.334" y1="542.145" x2="89.5748" y2="550.131"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint7_linear_28_1933" x1="142.066" y1="96.9504" x2="120.18" y2="126.177"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint8_linear_28_1933" x1="75.5046" y1="273.898" x2="75.5046" y2="293.694"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint9_linear_28_1933" x1="75.5061" y1="294.885" x2="75.5061" y2="310.946"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint10_linear_28_1933" x1="75.5159" y1="304.344" x2="75.5159" y2="310.934"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint11_linear_28_1933" x1="96.3961" y1="207.283" x2="96.3961" y2="226.641"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint12_linear_28_1933" x1="96.3981" y1="201.736" x2="96.3981" y2="205.884"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint13_linear_28_1933" x1="109.3" y1="188.722" x2="109.3" y2="200.364"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint14_linear_28_1933" x1="87.3615" y1="192.072" x2="87.3615" y2="200.328"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint15_linear_28_1933" x1="98.0337" y1="192.03" x2="98.0337" y2="200.34"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint16_linear_28_1933" x1="79.6614" y1="189.102" x2="79.6614" y2="200.334"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint17_linear_28_1933" x1="86.1926" y1="188.535" x2="86.1926" y2="190.625"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint18_linear_28_1933" x1="85.0028" y1="185.379" x2="85.0028" y2="187.133"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint19_linear_28_1933" x1="98.0366" y1="189.167" x2="98.0366" y2="190.599"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint20_linear_28_1933" x1="98.0272" y1="194.947" x2="98.0272" y2="197.721"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint21_linear_28_1933" x1="52.6023" y1="120.96" x2="52.6023" y2="149.489"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint22_linear_28_1933" x1="62.174" y1="120.965" x2="62.174" y2="126.645"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint23_linear_28_1933" x1="52.6574" y1="122.871" x2="52.6574" y2="126.645"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint24_linear_28_1933" x1="146.492" y1="250.035" x2="152.374" y2="266.365"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint25_linear_28_1933" x1="155.657" y1="240.656" x2="159.081" y2="250.161"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint26_linear_28_1933" x1="136.007" y1="271.489" x2="137.979" y2="276.964"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint27_linear_28_1933" x1="160.069" y1="263.617" x2="161.795" y2="268.409"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint28_linear_28_1933" x1="134.31" y1="266.753" x2="135.531" y2="270.142"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint29_linear_28_1933" x1="154.405" y1="237.222" x2="155.137" y2="239.254"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint30_linear_28_1933" x1="135.053" y1="249.579" x2="136.032" y2="252.296"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint31_linear_28_1933" x1="148.815" y1="251.533" x2="149.555" y2="253.587"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint32_linear_28_1933" x1="63.067" y1="470.799" x2="52.4971" y2="496.179"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint33_linear_28_1933" x1="81.1128" y1="464.419" x2="69.7318" y2="491.746"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint34_linear_28_1933" x1="81.1061" y1="464.451" x2="78.4098" y2="470.925"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint35_linear_28_1933" x1="59.4571" y1="479.372" x2="57.9443" y2="483.005"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint36_linear_28_1933" x1="44.848" y1="396.701" x2="32.4224" y2="414.803"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint37_linear_28_1933" x1="49.0148" y1="405.086" x2="48.2215" y2="406.241"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04F485" />
                        <stop offset="1" stop-color="#0DCB72" />
                    </linearGradient>
                    <linearGradient id="paint38_linear_28_1933" x1="44.5272" y1="55.9698" x2="52.0625" y2="63.2261"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint39_linear_28_1933" x1="-17.2045" y1="30.6751" x2="-3.77239" y2="43.6098"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint40_linear_28_1933" x1="-10.725" y1="98.7334" x2="-0.243503" y2="108.827"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                    <linearGradient id="paint41_linear_28_1933" x1="-20.1357" y1="34.1133" x2="43.1072" y2="95.0143"
                        gradientUnits="userSpaceOnUse">
                        <stop stop-color="#04B061" />
                        <stop offset="1" stop-color="#22FF98" />
                    </linearGradient>
                </defs>
            </svg>

        </section>
        <!-- ==== About Section ==== -->
@endsection
